package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.S3ExpirationInDays
import scala.jdk.CollectionConverters._
final case class S3InitiateRestoreObjectOperation(
    expirationInDays: Option[S3ExpirationInDays] = None,
    glacierJobTier: Option[zio.aws.s3control.model.S3GlacierJobTier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation = {
    import S3InitiateRestoreObjectOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation
      .builder()
      .optionallyWith(
        expirationInDays.map(value => S3ExpirationInDays.unwrap(value): Integer)
      )(_.expirationInDays)
      .optionallyWith(glacierJobTier.map(value => value.unwrap))(
        _.glacierJobTier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly =
    zio.aws.s3control.model.S3InitiateRestoreObjectOperation
      .wrap(buildAwsValue())
}
object S3InitiateRestoreObjectOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3InitiateRestoreObjectOperation =
      zio.aws.s3control.model.S3InitiateRestoreObjectOperation(
        expirationInDays.map(value => value),
        glacierJobTier.map(value => value)
      )
    def expirationInDays: Option[S3ExpirationInDays]
    def glacierJobTier: Option[zio.aws.s3control.model.S3GlacierJobTier]
    def getExpirationInDays: ZIO[Any, AwsError, S3ExpirationInDays] =
      AwsError.unwrapOptionField("expirationInDays", expirationInDays)
    def getGlacierJobTier
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3GlacierJobTier] =
      AwsError.unwrapOptionField("glacierJobTier", glacierJobTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation
  ) extends zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly {
    override val expirationInDays: Option[S3ExpirationInDays] = scala
      .Option(impl.expirationInDays())
      .map(value =>
        zio.aws.s3control.model.primitives.S3ExpirationInDays(value)
      )
    override val glacierJobTier
        : Option[zio.aws.s3control.model.S3GlacierJobTier] = scala
      .Option(impl.glacierJobTier())
      .map(value => zio.aws.s3control.model.S3GlacierJobTier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation
  ): zio.aws.s3control.model.S3InitiateRestoreObjectOperation.ReadOnly =
    new Wrapper(impl)
}
