package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{
  JobNumberOfTasksFailed,
  JobNumberOfTasksSucceeded,
  JobTotalNumberOfTasks
}
import scala.jdk.CollectionConverters._
final case class JobProgressSummary(
    totalNumberOfTasks: Option[JobTotalNumberOfTasks] = None,
    numberOfTasksSucceeded: Option[JobNumberOfTasksSucceeded] = None,
    numberOfTasksFailed: Option[JobNumberOfTasksFailed] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobProgressSummary = {
    import JobProgressSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobProgressSummary
      .builder()
      .optionallyWith(
        totalNumberOfTasks.map(value =>
          JobTotalNumberOfTasks.unwrap(value): java.lang.Long
        )
      )(_.totalNumberOfTasks)
      .optionallyWith(
        numberOfTasksSucceeded.map(value =>
          JobNumberOfTasksSucceeded.unwrap(value): java.lang.Long
        )
      )(_.numberOfTasksSucceeded)
      .optionallyWith(
        numberOfTasksFailed.map(value =>
          JobNumberOfTasksFailed.unwrap(value): java.lang.Long
        )
      )(_.numberOfTasksFailed)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobProgressSummary.ReadOnly =
    zio.aws.s3control.model.JobProgressSummary.wrap(buildAwsValue())
}
object JobProgressSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobProgressSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobProgressSummary =
      zio.aws.s3control.model.JobProgressSummary(
        totalNumberOfTasks.map(value => value),
        numberOfTasksSucceeded.map(value => value),
        numberOfTasksFailed.map(value => value)
      )
    def totalNumberOfTasks: Option[JobTotalNumberOfTasks]
    def numberOfTasksSucceeded: Option[JobNumberOfTasksSucceeded]
    def numberOfTasksFailed: Option[JobNumberOfTasksFailed]
    def getTotalNumberOfTasks: ZIO[Any, AwsError, JobTotalNumberOfTasks] =
      AwsError.unwrapOptionField("totalNumberOfTasks", totalNumberOfTasks)
    def getNumberOfTasksSucceeded
        : ZIO[Any, AwsError, JobNumberOfTasksSucceeded] = AwsError
      .unwrapOptionField("numberOfTasksSucceeded", numberOfTasksSucceeded)
    def getNumberOfTasksFailed: ZIO[Any, AwsError, JobNumberOfTasksFailed] =
      AwsError.unwrapOptionField("numberOfTasksFailed", numberOfTasksFailed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobProgressSummary
  ) extends zio.aws.s3control.model.JobProgressSummary.ReadOnly {
    override val totalNumberOfTasks: Option[JobTotalNumberOfTasks] = scala
      .Option(impl.totalNumberOfTasks())
      .map(value =>
        zio.aws.s3control.model.primitives.JobTotalNumberOfTasks(value)
      )
    override val numberOfTasksSucceeded: Option[JobNumberOfTasksSucceeded] =
      scala
        .Option(impl.numberOfTasksSucceeded())
        .map(value =>
          zio.aws.s3control.model.primitives.JobNumberOfTasksSucceeded(value)
        )
    override val numberOfTasksFailed: Option[JobNumberOfTasksFailed] = scala
      .Option(impl.numberOfTasksFailed())
      .map(value =>
        zio.aws.s3control.model.primitives.JobNumberOfTasksFailed(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobProgressSummary
  ): zio.aws.s3control.model.JobProgressSummary.ReadOnly = new Wrapper(impl)
}
