package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  JobTerminationDate,
  JobPriority,
  JobId,
  NonEmptyMaxLength256String,
  JobCreationTime
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class JobListDescriptor(
    jobId: Option[JobId] = None,
    description: Option[NonEmptyMaxLength256String] = None,
    operation: Option[zio.aws.s3control.model.OperationName] = None,
    priority: Option[JobPriority] = None,
    status: Option[zio.aws.s3control.model.JobStatus] = None,
    creationTime: Option[JobCreationTime] = None,
    terminationDate: Option[JobTerminationDate] = None,
    progressSummary: Option[zio.aws.s3control.model.JobProgressSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobListDescriptor = {
    import JobListDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobListDescriptor
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        description.map(value =>
          NonEmptyMaxLength256String.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(operation.map(value => value.unwrap))(_.operation)
      .optionallyWith(
        priority.map(value => JobPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => JobCreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationDate.map(value => JobTerminationDate.unwrap(value): Instant)
      )(_.terminationDate)
      .optionallyWith(progressSummary.map(value => value.buildAwsValue()))(
        _.progressSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobListDescriptor.ReadOnly =
    zio.aws.s3control.model.JobListDescriptor.wrap(buildAwsValue())
}
object JobListDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobListDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobListDescriptor =
      zio.aws.s3control.model.JobListDescriptor(
        jobId.map(value => value),
        description.map(value => value),
        operation.map(value => value),
        priority.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        terminationDate.map(value => value),
        progressSummary.map(value => value.asEditable)
      )
    def jobId: Option[JobId]
    def description: Option[NonEmptyMaxLength256String]
    def operation: Option[zio.aws.s3control.model.OperationName]
    def priority: Option[JobPriority]
    def status: Option[zio.aws.s3control.model.JobStatus]
    def creationTime: Option[JobCreationTime]
    def terminationDate: Option[JobTerminationDate]
    def progressSummary
        : Option[zio.aws.s3control.model.JobProgressSummary.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDescription: ZIO[Any, AwsError, NonEmptyMaxLength256String] =
      AwsError.unwrapOptionField("description", description)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.s3control.model.OperationName] =
      AwsError.unwrapOptionField("operation", operation)
    def getPriority: ZIO[Any, AwsError, JobPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getStatus: ZIO[Any, AwsError, zio.aws.s3control.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, JobCreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationDate: ZIO[Any, AwsError, JobTerminationDate] =
      AwsError.unwrapOptionField("terminationDate", terminationDate)
    def getProgressSummary: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobProgressSummary.ReadOnly
    ] = AwsError.unwrapOptionField("progressSummary", progressSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobListDescriptor
  ) extends zio.aws.s3control.model.JobListDescriptor.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.s3control.model.primitives.JobId(value))
    override val description: Option[NonEmptyMaxLength256String] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.s3control.model.primitives.NonEmptyMaxLength256String(value)
      )
    override val operation: Option[zio.aws.s3control.model.OperationName] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.s3control.model.OperationName.wrap(value))
    override val priority: Option[JobPriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.s3control.model.primitives.JobPriority(value))
    override val status: Option[zio.aws.s3control.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.s3control.model.JobStatus.wrap(value))
    override val creationTime: Option[JobCreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.s3control.model.primitives.JobCreationTime(value))
    override val terminationDate: Option[JobTerminationDate] = scala
      .Option(impl.terminationDate())
      .map(value =>
        zio.aws.s3control.model.primitives.JobTerminationDate(value)
      )
    override val progressSummary
        : Option[zio.aws.s3control.model.JobProgressSummary.ReadOnly] = scala
      .Option(impl.progressSummary())
      .map(value => zio.aws.s3control.model.JobProgressSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobListDescriptor
  ): zio.aws.s3control.model.JobListDescriptor.ReadOnly = new Wrapper(impl)
}
