package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.s3control.model.primitives.{Prefix, S3BucketArnString, AccountId}
import scala.jdk.CollectionConverters._
final case class S3BucketDestination(
    format: zio.aws.s3control.model.Format,
    outputSchemaVersion: zio.aws.s3control.model.OutputSchemaVersion,
    accountId: AccountId,
    arn: S3BucketArnString,
    prefix: Option[Prefix] = None,
    encryption: Option[
      zio.aws.s3control.model.StorageLensDataExportEncryption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3BucketDestination = {
    import S3BucketDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3BucketDestination
      .builder()
      .format(format.unwrap)
      .outputSchemaVersion(outputSchemaVersion.unwrap)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .arn(S3BucketArnString.unwrap(arn): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3BucketDestination.ReadOnly =
    zio.aws.s3control.model.S3BucketDestination.wrap(buildAwsValue())
}
object S3BucketDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3BucketDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3BucketDestination =
      zio.aws.s3control.model.S3BucketDestination(
        format,
        outputSchemaVersion,
        accountId,
        arn,
        prefix.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def format: zio.aws.s3control.model.Format
    def outputSchemaVersion: zio.aws.s3control.model.OutputSchemaVersion
    def accountId: AccountId
    def arn: S3BucketArnString
    def prefix: Option[Prefix]
    def encryption: Option[
      zio.aws.s3control.model.StorageLensDataExportEncryption.ReadOnly
    ]
    def getFormat: ZIO[Any, Nothing, zio.aws.s3control.model.Format] =
      ZIO.succeed(format)
    def getOutputSchemaVersion
        : ZIO[Any, Nothing, zio.aws.s3control.model.OutputSchemaVersion] =
      ZIO.succeed(outputSchemaVersion)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getArn: ZIO[Any, Nothing, S3BucketArnString] = ZIO.succeed(arn)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.StorageLensDataExportEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3BucketDestination
  ) extends zio.aws.s3control.model.S3BucketDestination.ReadOnly {
    override val format: zio.aws.s3control.model.Format =
      zio.aws.s3control.model.Format.wrap(impl.format())
    override val outputSchemaVersion
        : zio.aws.s3control.model.OutputSchemaVersion =
      zio.aws.s3control.model.OutputSchemaVersion
        .wrap(impl.outputSchemaVersion())
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val arn: S3BucketArnString =
      zio.aws.s3control.model.primitives.S3BucketArnString(impl.arn())
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3control.model.primitives.Prefix(value))
    override val encryption: Option[
      zio.aws.s3control.model.StorageLensDataExportEncryption.ReadOnly
    ] = scala
      .Option(impl.encryption())
      .map(value =>
        zio.aws.s3control.model.StorageLensDataExportEncryption.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3BucketDestination
  ): zio.aws.s3control.model.S3BucketDestination.ReadOnly = new Wrapper(impl)
}
