package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeJobResponse(
    job: Option[zio.aws.s3control.model.JobDescriptor] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DescribeJobResponse = {
    import DescribeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DescribeJobResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.DescribeJobResponse.ReadOnly =
    zio.aws.s3control.model.DescribeJobResponse.wrap(buildAwsValue())
}
object DescribeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DescribeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DescribeJobResponse =
      zio.aws.s3control.model
        .DescribeJobResponse(job.map(value => value.asEditable))
    def job: Option[zio.aws.s3control.model.JobDescriptor.ReadOnly]
    def getJob
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobDescriptor.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DescribeJobResponse
  ) extends zio.aws.s3control.model.DescribeJobResponse.ReadOnly {
    override val job: Option[zio.aws.s3control.model.JobDescriptor.ReadOnly] =
      scala
        .Option(impl.job())
        .map(value => zio.aws.s3control.model.JobDescriptor.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DescribeJobResponse
  ): zio.aws.s3control.model.DescribeJobResponse.ReadOnly = new Wrapper(impl)
}
