package zio.aws.s3control
import zio.aws.s3control.model.PutJobTaggingResponse.ReadOnly
import zio.aws.s3control.model.{
  PutAccessPointPolicyForObjectLambdaRequest,
  PutBucketPolicyRequest,
  CreateMultiRegionAccessPointRequest,
  DeleteBucketLifecycleConfigurationRequest,
  ListMultiRegionAccessPointsRequest,
  GetAccessPointPolicyStatusRequest,
  GetBucketRequest,
  PutBucketLifecycleConfigurationRequest,
  GetMultiRegionAccessPointPolicyStatusRequest,
  PutAccessPointConfigurationForObjectLambdaRequest,
  GetAccessPointConfigurationForObjectLambdaRequest,
  GetBucketPolicyRequest,
  GetStorageLensConfigurationRequest,
  DescribeMultiRegionAccessPointOperationRequest,
  GetAccessPointForObjectLambdaRequest,
  DeleteBucketTaggingRequest,
  ListJobsRequest,
  GetAccessPointPolicyForObjectLambdaRequest,
  GetAccessPointRequest,
  CreateAccessPointForObjectLambdaRequest,
  DescribeJobRequest,
  GetMultiRegionAccessPointRequest,
  DeleteAccessPointForObjectLambdaRequest,
  DeleteStorageLensConfigurationTaggingRequest,
  DeleteJobTaggingRequest,
  PutStorageLensConfigurationTaggingRequest,
  PutPublicAccessBlockRequest,
  GetBucketTaggingRequest,
  DeleteAccessPointPolicyForObjectLambdaRequest,
  GetStorageLensConfigurationTaggingRequest,
  GetJobTaggingRequest,
  GetPublicAccessBlockRequest,
  DeletePublicAccessBlockRequest,
  ListAccessPointsRequest,
  DeleteAccessPointPolicyRequest,
  GetBucketLifecycleConfigurationRequest,
  DeleteBucketRequest,
  UpdateJobStatusRequest,
  CreateBucketRequest,
  ListAccessPointsForObjectLambdaRequest,
  GetAccessPointPolicyRequest,
  DeleteStorageLensConfigurationRequest,
  PutStorageLensConfigurationRequest,
  DeleteBucketPolicyRequest,
  PutJobTaggingRequest,
  ListStorageLensConfigurationsRequest,
  CreateJobRequest,
  DeleteMultiRegionAccessPointRequest,
  UpdateJobPriorityRequest,
  PutMultiRegionAccessPointPolicyRequest,
  GetMultiRegionAccessPointPolicyRequest,
  PutAccessPointPolicyRequest,
  PutBucketTaggingRequest,
  ListRegionalBucketsRequest,
  DeleteAccessPointRequest,
  GetAccessPointPolicyStatusForObjectLambdaRequest,
  CreateAccessPointRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object S3ControlMock extends Mock[S3Control] {
  object PutBucketPolicy extends Effect[PutBucketPolicyRequest, AwsError, Unit]
  object GetBucketPolicy
      extends Effect[
        GetBucketPolicyRequest,
        AwsError,
        zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly
      ]
  object CreateMultiRegionAccessPoint
      extends Effect[
        CreateMultiRegionAccessPointRequest,
        AwsError,
        zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly
      ]
  object DescribeJob
      extends Effect[
        DescribeJobRequest,
        AwsError,
        zio.aws.s3control.model.DescribeJobResponse.ReadOnly
      ]
  object GetBucket
      extends Effect[
        GetBucketRequest,
        AwsError,
        zio.aws.s3control.model.GetBucketResponse.ReadOnly
      ]
  object DeleteAccessPointPolicy
      extends Effect[DeleteAccessPointPolicyRequest, AwsError, Unit]
  object PutBucketLifecycleConfiguration
      extends Effect[PutBucketLifecycleConfigurationRequest, AwsError, Unit]
  object CreateAccessPoint
      extends Effect[
        CreateAccessPointRequest,
        AwsError,
        zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly
      ]
  object DeleteBucketPolicy
      extends Effect[DeleteBucketPolicyRequest, AwsError, Unit]
  object GetAccessPointPolicyStatusForObjectLambda
      extends Effect[
        GetAccessPointPolicyStatusForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly
      ]
  object GetBucketLifecycleConfiguration
      extends Effect[
        GetBucketLifecycleConfigurationRequest,
        AwsError,
        zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly
      ]
  object DeleteJobTagging
      extends Effect[
        DeleteJobTaggingRequest,
        AwsError,
        zio.aws.s3control.model.DeleteJobTaggingResponse.ReadOnly
      ]
  object DeleteBucketLifecycleConfiguration
      extends Effect[DeleteBucketLifecycleConfigurationRequest, AwsError, Unit]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.s3control.model.CreateJobResponse.ReadOnly
      ]
  object GetStorageLensConfiguration
      extends Effect[
        GetStorageLensConfigurationRequest,
        AwsError,
        zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly
      ]
  object DeleteAccessPointPolicyForObjectLambda
      extends Effect[
        DeleteAccessPointPolicyForObjectLambdaRequest,
        AwsError,
        Unit
      ]
  object PutAccessPointConfigurationForObjectLambda
      extends Effect[
        PutAccessPointConfigurationForObjectLambdaRequest,
        AwsError,
        Unit
      ]
  object PutAccessPointPolicy
      extends Effect[PutAccessPointPolicyRequest, AwsError, Unit]
  object PutAccessPointPolicyForObjectLambda
      extends Effect[PutAccessPointPolicyForObjectLambdaRequest, AwsError, Unit]
  object GetMultiRegionAccessPoint
      extends Effect[
        GetMultiRegionAccessPointRequest,
        AwsError,
        zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly
      ]
  object GetAccessPoint
      extends Effect[
        GetAccessPointRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointResponse.ReadOnly
      ]
  object DeleteStorageLensConfigurationTagging
      extends Effect[
        DeleteStorageLensConfigurationTaggingRequest,
        AwsError,
        zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingResponse.ReadOnly
      ]
  object DeleteBucket extends Effect[DeleteBucketRequest, AwsError, Unit]
  object CreateBucket
      extends Effect[
        CreateBucketRequest,
        AwsError,
        zio.aws.s3control.model.CreateBucketResponse.ReadOnly
      ]
  object UpdateJobStatus
      extends Effect[
        UpdateJobStatusRequest,
        AwsError,
        zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly
      ]
  object GetBucketTagging
      extends Effect[
        GetBucketTaggingRequest,
        AwsError,
        zio.aws.s3control.model.GetBucketTaggingResponse.ReadOnly
      ]
  object PutStorageLensConfiguration
      extends Effect[PutStorageLensConfigurationRequest, AwsError, Unit]
  object PutBucketTagging
      extends Effect[PutBucketTaggingRequest, AwsError, Unit]
  object DeleteBucketTagging
      extends Effect[DeleteBucketTaggingRequest, AwsError, Unit]
  object UpdateJobPriority
      extends Effect[
        UpdateJobPriorityRequest,
        AwsError,
        zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly
      ]
  object ListStorageLensConfigurations
      extends Stream[
        ListStorageLensConfigurationsRequest,
        AwsError,
        zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
      ]
  object ListStorageLensConfigurationsPaginated
      extends Effect[
        ListStorageLensConfigurationsRequest,
        AwsError,
        zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly
      ]
  object PutPublicAccessBlock
      extends Effect[PutPublicAccessBlockRequest, AwsError, Unit]
  object GetMultiRegionAccessPointPolicy
      extends Effect[
        GetMultiRegionAccessPointPolicyRequest,
        AwsError,
        zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly
      ]
  object ListRegionalBuckets
      extends Stream[
        ListRegionalBucketsRequest,
        AwsError,
        zio.aws.s3control.model.RegionalBucket.ReadOnly
      ]
  object ListRegionalBucketsPaginated
      extends Effect[
        ListRegionalBucketsRequest,
        AwsError,
        zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly
      ]
  object GetAccessPointPolicyForObjectLambda
      extends Effect[
        GetAccessPointPolicyForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly
      ]
  object GetAccessPointForObjectLambda
      extends Effect[
        GetAccessPointForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.s3control.model.JobListDescriptor.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.s3control.model.ListJobsResponse.ReadOnly
      ]
  object ListAccessPointsForObjectLambda
      extends Stream[
        ListAccessPointsForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly
      ]
  object ListAccessPointsForObjectLambdaPaginated
      extends Effect[
        ListAccessPointsForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly
      ]
  object ListMultiRegionAccessPoints
      extends Stream[
        ListMultiRegionAccessPointsRequest,
        AwsError,
        zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
      ]
  object ListMultiRegionAccessPointsPaginated
      extends Effect[
        ListMultiRegionAccessPointsRequest,
        AwsError,
        zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly
      ]
  object GetMultiRegionAccessPointPolicyStatus
      extends Effect[
        GetMultiRegionAccessPointPolicyStatusRequest,
        AwsError,
        zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly
      ]
  object GetPublicAccessBlock
      extends Effect[
        GetPublicAccessBlockRequest,
        AwsError,
        zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly
      ]
  object DeleteMultiRegionAccessPoint
      extends Effect[
        DeleteMultiRegionAccessPointRequest,
        AwsError,
        zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly
      ]
  object GetAccessPointPolicyStatus
      extends Effect[
        GetAccessPointPolicyStatusRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly
      ]
  object GetStorageLensConfigurationTagging
      extends Effect[
        GetStorageLensConfigurationTaggingRequest,
        AwsError,
        zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly
      ]
  object DescribeMultiRegionAccessPointOperation
      extends Effect[
        DescribeMultiRegionAccessPointOperationRequest,
        AwsError,
        zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly
      ]
  object DeleteAccessPointForObjectLambda
      extends Effect[DeleteAccessPointForObjectLambdaRequest, AwsError, Unit]
  object ListAccessPoints
      extends Stream[
        ListAccessPointsRequest,
        AwsError,
        zio.aws.s3control.model.AccessPoint.ReadOnly
      ]
  object ListAccessPointsPaginated
      extends Effect[
        ListAccessPointsRequest,
        AwsError,
        zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly
      ]
  object GetAccessPointPolicy
      extends Effect[
        GetAccessPointPolicyRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointPolicyResponse.ReadOnly
      ]
  object DeleteStorageLensConfiguration
      extends Effect[DeleteStorageLensConfigurationRequest, AwsError, Unit]
  object CreateAccessPointForObjectLambda
      extends Effect[
        CreateAccessPointForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly
      ]
  object PutJobTagging extends Effect[PutJobTaggingRequest, AwsError, ReadOnly]
  object DeletePublicAccessBlock
      extends Effect[DeletePublicAccessBlockRequest, AwsError, Unit]
  object DeleteAccessPoint
      extends Effect[DeleteAccessPointRequest, AwsError, Unit]
  object PutMultiRegionAccessPointPolicy
      extends Effect[
        PutMultiRegionAccessPointPolicyRequest,
        AwsError,
        zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly
      ]
  object GetJobTagging
      extends Effect[
        GetJobTaggingRequest,
        AwsError,
        zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly
      ]
  object PutStorageLensConfigurationTagging
      extends Effect[
        PutStorageLensConfigurationTaggingRequest,
        AwsError,
        zio.aws.s3control.model.PutStorageLensConfigurationTaggingResponse.ReadOnly
      ]
  object GetAccessPointConfigurationForObjectLambda
      extends Effect[
        GetAccessPointConfigurationForObjectLambdaRequest,
        AwsError,
        zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, S3Control] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new S3Control {
          val api: S3ControlAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : S3Control = this
          def putBucketPolicy(
              request: PutBucketPolicyRequest
          ): IO[AwsError, Unit] = proxy(PutBucketPolicy, request)
          def getBucketPolicy(request: GetBucketPolicyRequest): IO[
            AwsError,
            zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly
          ] = proxy(GetBucketPolicy, request)
          def createMultiRegionAccessPoint(
              request: CreateMultiRegionAccessPointRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.CreateMultiRegionAccessPointResponse.ReadOnly
          ] = proxy(CreateMultiRegionAccessPoint, request)
          def describeJob(request: DescribeJobRequest): IO[
            AwsError,
            zio.aws.s3control.model.DescribeJobResponse.ReadOnly
          ] = proxy(DescribeJob, request)
          def getBucket(
              request: GetBucketRequest
          ): IO[AwsError, zio.aws.s3control.model.GetBucketResponse.ReadOnly] =
            proxy(GetBucket, request)
          def deleteAccessPointPolicy(
              request: DeleteAccessPointPolicyRequest
          ): IO[AwsError, Unit] = proxy(DeleteAccessPointPolicy, request)
          def putBucketLifecycleConfiguration(
              request: PutBucketLifecycleConfigurationRequest
          ): IO[AwsError, Unit] =
            proxy(PutBucketLifecycleConfiguration, request)
          def createAccessPoint(request: CreateAccessPointRequest): IO[
            AwsError,
            zio.aws.s3control.model.CreateAccessPointResponse.ReadOnly
          ] = proxy(CreateAccessPoint, request)
          def deleteBucketPolicy(
              request: DeleteBucketPolicyRequest
          ): IO[AwsError, Unit] = proxy(DeleteBucketPolicy, request)
          def getAccessPointPolicyStatusForObjectLambda(
              request: GetAccessPointPolicyStatusForObjectLambdaRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse.ReadOnly
          ] = proxy(GetAccessPointPolicyStatusForObjectLambda, request)
          def getBucketLifecycleConfiguration(
              request: GetBucketLifecycleConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly
          ] = proxy(GetBucketLifecycleConfiguration, request)
          def deleteJobTagging(request: DeleteJobTaggingRequest): IO[
            AwsError,
            zio.aws.s3control.model.DeleteJobTaggingResponse.ReadOnly
          ] = proxy(DeleteJobTagging, request)
          def deleteBucketLifecycleConfiguration(
              request: DeleteBucketLifecycleConfigurationRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteBucketLifecycleConfiguration, request)
          def createJob(
              request: CreateJobRequest
          ): IO[AwsError, zio.aws.s3control.model.CreateJobResponse.ReadOnly] =
            proxy(CreateJob, request)
          def getStorageLensConfiguration(
              request: GetStorageLensConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetStorageLensConfigurationResponse.ReadOnly
          ] = proxy(GetStorageLensConfiguration, request)
          def deleteAccessPointPolicyForObjectLambda(
              request: DeleteAccessPointPolicyForObjectLambdaRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteAccessPointPolicyForObjectLambda, request)
          def putAccessPointConfigurationForObjectLambda(
              request: PutAccessPointConfigurationForObjectLambdaRequest
          ): IO[AwsError, Unit] =
            proxy(PutAccessPointConfigurationForObjectLambda, request)
          def putAccessPointPolicy(
              request: PutAccessPointPolicyRequest
          ): IO[AwsError, Unit] = proxy(PutAccessPointPolicy, request)
          def putAccessPointPolicyForObjectLambda(
              request: PutAccessPointPolicyForObjectLambdaRequest
          ): IO[AwsError, Unit] =
            proxy(PutAccessPointPolicyForObjectLambda, request)
          def getMultiRegionAccessPoint(
              request: GetMultiRegionAccessPointRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetMultiRegionAccessPointResponse.ReadOnly
          ] = proxy(GetMultiRegionAccessPoint, request)
          def getAccessPoint(request: GetAccessPointRequest): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointResponse.ReadOnly
          ] = proxy(GetAccessPoint, request)
          def deleteStorageLensConfigurationTagging(
              request: DeleteStorageLensConfigurationTaggingRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.DeleteStorageLensConfigurationTaggingResponse.ReadOnly
          ] = proxy(DeleteStorageLensConfigurationTagging, request)
          def deleteBucket(request: DeleteBucketRequest): IO[AwsError, Unit] =
            proxy(DeleteBucket, request)
          def createBucket(request: CreateBucketRequest): IO[
            AwsError,
            zio.aws.s3control.model.CreateBucketResponse.ReadOnly
          ] = proxy(CreateBucket, request)
          def updateJobStatus(request: UpdateJobStatusRequest): IO[
            AwsError,
            zio.aws.s3control.model.UpdateJobStatusResponse.ReadOnly
          ] = proxy(UpdateJobStatus, request)
          def getBucketTagging(request: GetBucketTaggingRequest): IO[
            AwsError,
            zio.aws.s3control.model.GetBucketTaggingResponse.ReadOnly
          ] = proxy(GetBucketTagging, request)
          def putStorageLensConfiguration(
              request: PutStorageLensConfigurationRequest
          ): IO[AwsError, Unit] = proxy(PutStorageLensConfiguration, request)
          def putBucketTagging(
              request: PutBucketTaggingRequest
          ): IO[AwsError, Unit] = proxy(PutBucketTagging, request)
          def deleteBucketTagging(
              request: DeleteBucketTaggingRequest
          ): IO[AwsError, Unit] = proxy(DeleteBucketTagging, request)
          def updateJobPriority(request: UpdateJobPriorityRequest): IO[
            AwsError,
            zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly
          ] = proxy(UpdateJobPriority, request)
          def listStorageLensConfigurations(
              request: ListStorageLensConfigurationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListStorageLensConfigurations, request))
          def listStorageLensConfigurationsPaginated(
              request: ListStorageLensConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly
          ] = proxy(ListStorageLensConfigurationsPaginated, request)
          def putPublicAccessBlock(
              request: PutPublicAccessBlockRequest
          ): IO[AwsError, Unit] = proxy(PutPublicAccessBlock, request)
          def getMultiRegionAccessPointPolicy(
              request: GetMultiRegionAccessPointPolicyRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetMultiRegionAccessPointPolicyResponse.ReadOnly
          ] = proxy(GetMultiRegionAccessPointPolicy, request)
          def listRegionalBuckets(request: ListRegionalBucketsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.s3control.model.RegionalBucket.ReadOnly
          ] = rts.unsafeRun(proxy(ListRegionalBuckets, request))
          def listRegionalBucketsPaginated(
              request: ListRegionalBucketsRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.ListRegionalBucketsResponse.ReadOnly
          ] = proxy(ListRegionalBucketsPaginated, request)
          def getAccessPointPolicyForObjectLambda(
              request: GetAccessPointPolicyForObjectLambdaRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaResponse.ReadOnly
          ] = proxy(GetAccessPointPolicyForObjectLambda, request)
          def getAccessPointForObjectLambda(
              request: GetAccessPointForObjectLambdaRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly
          ] = proxy(GetAccessPointForObjectLambda, request)
          def listJobs(request: ListJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.s3control.model.JobListDescriptor.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.s3control.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobsPaginated, request)
          def listAccessPointsForObjectLambda(
              request: ListAccessPointsForObjectLambdaRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly
          ] = rts.unsafeRun(proxy(ListAccessPointsForObjectLambda, request))
          def listAccessPointsForObjectLambdaPaginated(
              request: ListAccessPointsForObjectLambdaRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.ListAccessPointsForObjectLambdaResponse.ReadOnly
          ] = proxy(ListAccessPointsForObjectLambdaPaginated, request)
          def listMultiRegionAccessPoints(
              request: ListMultiRegionAccessPointsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.s3control.model.MultiRegionAccessPointReport.ReadOnly
          ] = rts.unsafeRun(proxy(ListMultiRegionAccessPoints, request))
          def listMultiRegionAccessPointsPaginated(
              request: ListMultiRegionAccessPointsRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.ListMultiRegionAccessPointsResponse.ReadOnly
          ] = proxy(ListMultiRegionAccessPointsPaginated, request)
          def getMultiRegionAccessPointPolicyStatus(
              request: GetMultiRegionAccessPointPolicyStatusRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse.ReadOnly
          ] = proxy(GetMultiRegionAccessPointPolicyStatus, request)
          def getPublicAccessBlock(request: GetPublicAccessBlockRequest): IO[
            AwsError,
            zio.aws.s3control.model.GetPublicAccessBlockResponse.ReadOnly
          ] = proxy(GetPublicAccessBlock, request)
          def deleteMultiRegionAccessPoint(
              request: DeleteMultiRegionAccessPointRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.DeleteMultiRegionAccessPointResponse.ReadOnly
          ] = proxy(DeleteMultiRegionAccessPoint, request)
          def getAccessPointPolicyStatus(
              request: GetAccessPointPolicyStatusRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly
          ] = proxy(GetAccessPointPolicyStatus, request)
          def getStorageLensConfigurationTagging(
              request: GetStorageLensConfigurationTaggingRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetStorageLensConfigurationTaggingResponse.ReadOnly
          ] = proxy(GetStorageLensConfigurationTagging, request)
          def describeMultiRegionAccessPointOperation(
              request: DescribeMultiRegionAccessPointOperationRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly
          ] = proxy(DescribeMultiRegionAccessPointOperation, request)
          def deleteAccessPointForObjectLambda(
              request: DeleteAccessPointForObjectLambdaRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteAccessPointForObjectLambda, request)
          def listAccessPoints(request: ListAccessPointsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.s3control.model.AccessPoint.ReadOnly
          ] = rts.unsafeRun(proxy(ListAccessPoints, request))
          def listAccessPointsPaginated(request: ListAccessPointsRequest): IO[
            AwsError,
            zio.aws.s3control.model.ListAccessPointsResponse.ReadOnly
          ] = proxy(ListAccessPointsPaginated, request)
          def getAccessPointPolicy(request: GetAccessPointPolicyRequest): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointPolicyResponse.ReadOnly
          ] = proxy(GetAccessPointPolicy, request)
          def deleteStorageLensConfiguration(
              request: DeleteStorageLensConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteStorageLensConfiguration, request)
          def createAccessPointForObjectLambda(
              request: CreateAccessPointForObjectLambdaRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.CreateAccessPointForObjectLambdaResponse.ReadOnly
          ] = proxy(CreateAccessPointForObjectLambda, request)
          def putJobTagging(
              request: PutJobTaggingRequest
          ): IO[AwsError, ReadOnly] = proxy(PutJobTagging, request)
          def deletePublicAccessBlock(
              request: DeletePublicAccessBlockRequest
          ): IO[AwsError, Unit] = proxy(DeletePublicAccessBlock, request)
          def deleteAccessPoint(
              request: DeleteAccessPointRequest
          ): IO[AwsError, Unit] = proxy(DeleteAccessPoint, request)
          def putMultiRegionAccessPointPolicy(
              request: PutMultiRegionAccessPointPolicyRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly
          ] = proxy(PutMultiRegionAccessPointPolicy, request)
          def getJobTagging(request: GetJobTaggingRequest): IO[
            AwsError,
            zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly
          ] = proxy(GetJobTagging, request)
          def putStorageLensConfigurationTagging(
              request: PutStorageLensConfigurationTaggingRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.PutStorageLensConfigurationTaggingResponse.ReadOnly
          ] = proxy(PutStorageLensConfigurationTagging, request)
          def getAccessPointConfigurationForObjectLambda(
              request: GetAccessPointConfigurationForObjectLambdaRequest
          ): IO[
            AwsError,
            zio.aws.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse.ReadOnly
          ] = proxy(GetAccessPointConfigurationForObjectLambda, request)
        }
      }
    }
    .toLayer
}
