package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.{Ipv6, ResourceId}
import scala.jdk.CollectionConverters.*
final case class UpdateIpAddress(ipId: ResourceId, ipv6: Ipv6) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress = {
    import UpdateIpAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress
      .builder()
      .ipId(ResourceId.unwrap(ipId): java.lang.String)
      .ipv6(Ipv6.unwrap(ipv6): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.UpdateIpAddress.ReadOnly =
    zio.aws.route53resolver.model.UpdateIpAddress.wrap(buildAwsValue())
}
object UpdateIpAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateIpAddress =
      zio.aws.route53resolver.model.UpdateIpAddress(ipId, ipv6)
    def ipId: ResourceId
    def ipv6: Ipv6
    def getIpId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipId)
    def getIpv6: ZIO[Any, Nothing, Ipv6] = ZIO.succeed(ipv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress
  ) extends zio.aws.route53resolver.model.UpdateIpAddress.ReadOnly {
    override val ipId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.ipId())
    override val ipv6: Ipv6 =
      zio.aws.route53resolver.model.primitives.Ipv6(impl.ipv6())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress
  ): zio.aws.route53resolver.model.UpdateIpAddress.ReadOnly = new Wrapper(impl)
}
