package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallRuleResponse(
    firewallRule: Optional[zio.aws.route53resolver.model.FirewallRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse = {
    import UpdateFirewallRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
      .builder()
      .optionallyWith(firewallRule.map(value => value.buildAwsValue()))(
        _.firewallRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallRuleResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateFirewallRuleResponse =
      zio.aws.route53resolver.model
        .UpdateFirewallRuleResponse(firewallRule.map(value => value.asEditable))
    def firewallRule
        : Optional[zio.aws.route53resolver.model.FirewallRule.ReadOnly]
    def getFirewallRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRule.ReadOnly
    ] = AwsError.unwrapOptionField("firewallRule", firewallRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
  ) extends zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly {
    override val firewallRule
        : Optional[zio.aws.route53resolver.model.FirewallRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRule())
        .map(value => zio.aws.route53resolver.model.FirewallRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse
  ): zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly =
    new Wrapper(impl)
}
