package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait ResolverRuleStatus {
  def unwrap
      : software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus
}
object ResolverRuleStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus
  ): zio.aws.route53resolver.model.ResolverRuleStatus = value match {
    case software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.ResolverRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus =
      software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE
      extends zio.aws.route53resolver.model.ResolverRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus =
      software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.COMPLETE
  }
  case object DELETING
      extends zio.aws.route53resolver.model.ResolverRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus =
      software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.DELETING
  }
  case object UPDATING
      extends zio.aws.route53resolver.model.ResolverRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus =
      software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.UPDATING
  }
  case object FAILED extends zio.aws.route53resolver.model.ResolverRuleStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus =
      software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus.FAILED
  }
}
