package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  OutpostArn,
  CreatorRequestId,
  OutpostResolverName,
  Arn,
  OutpostInstanceType,
  Rfc3339TimeString,
  InstanceCount,
  ResourceId,
  OutpostResolverStatusMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class OutpostResolver(
    arn: Optional[Arn] = Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    id: Optional[ResourceId] = Optional.Absent,
    instanceCount: Optional[InstanceCount] = Optional.Absent,
    preferredInstanceType: Optional[OutpostInstanceType] = Optional.Absent,
    name: Optional[OutpostResolverName] = Optional.Absent,
    status: Optional[zio.aws.route53resolver.model.OutpostResolverStatus] =
      Optional.Absent,
    statusMessage: Optional[OutpostResolverStatusMessage] = Optional.Absent,
    outpostArn: Optional[OutpostArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.OutpostResolver = {
    import OutpostResolver.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.OutpostResolver
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        instanceCount.map(value => InstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .optionallyWith(
        preferredInstanceType.map(value =>
          OutpostInstanceType.unwrap(value): java.lang.String
        )
      )(_.preferredInstanceType)
      .optionallyWith(
        name.map(value => OutpostResolverName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          OutpostResolverStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        outpostArn.map(value => OutpostArn.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.OutpostResolver.ReadOnly =
    zio.aws.route53resolver.model.OutpostResolver.wrap(buildAwsValue())
}
object OutpostResolver {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.OutpostResolver
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.OutpostResolver =
      zio.aws.route53resolver.model.OutpostResolver(
        arn.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value),
        creatorRequestId.map(value => value),
        id.map(value => value),
        instanceCount.map(value => value),
        preferredInstanceType.map(value => value),
        name.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        outpostArn.map(value => value)
      )
    def arn: Optional[Arn]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def creatorRequestId: Optional[CreatorRequestId]
    def id: Optional[ResourceId]
    def instanceCount: Optional[InstanceCount]
    def preferredInstanceType: Optional[OutpostInstanceType]
    def name: Optional[OutpostResolverName]
    def status: Optional[zio.aws.route53resolver.model.OutpostResolverStatus]
    def statusMessage: Optional[OutpostResolverStatusMessage]
    def outpostArn: Optional[OutpostArn]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getInstanceCount: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getPreferredInstanceType: ZIO[Any, AwsError, OutpostInstanceType] =
      AwsError.unwrapOptionField("preferredInstanceType", preferredInstanceType)
    def getName: ZIO[Any, AwsError, OutpostResolverName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.OutpostResolverStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, OutpostResolverStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getOutpostArn: ZIO[Any, AwsError, OutpostArn] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.OutpostResolver
  ) extends zio.aws.route53resolver.model.OutpostResolver.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val instanceCount: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value =>
        zio.aws.route53resolver.model.primitives.InstanceCount(value)
      )
    override val preferredInstanceType: Optional[OutpostInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredInstanceType())
        .map(value =>
          zio.aws.route53resolver.model.primitives.OutpostInstanceType(value)
        )
    override val name: Optional[OutpostResolverName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.route53resolver.model.primitives.OutpostResolverName(value)
      )
    override val status
        : Optional[zio.aws.route53resolver.model.OutpostResolverStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.OutpostResolverStatus.wrap(value)
        )
    override val statusMessage: Optional[OutpostResolverStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.route53resolver.model.primitives
            .OutpostResolverStatusMessage(value)
        )
    override val outpostArn: Optional[OutpostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => zio.aws.route53resolver.model.primitives.OutpostArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.OutpostResolver
  ): zio.aws.route53resolver.model.OutpostResolver.ReadOnly = new Wrapper(impl)
}
