package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  OutpostInstanceType,
  InstanceCount,
  OutpostResolverName,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateOutpostResolverRequest(
    id: ResourceId,
    name: Optional[OutpostResolverName] = Optional.Absent,
    instanceCount: Optional[InstanceCount] = Optional.Absent,
    preferredInstanceType: Optional[OutpostInstanceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest = {
    import UpdateOutpostResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => OutpostResolverName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceCount.map(value => InstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .optionallyWith(
        preferredInstanceType.map(value =>
          OutpostInstanceType.unwrap(value): java.lang.String
        )
      )(_.preferredInstanceType)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateOutpostResolverRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateOutpostResolverRequest
      .wrap(buildAwsValue())
}
object UpdateOutpostResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateOutpostResolverRequest =
      zio.aws.route53resolver.model.UpdateOutpostResolverRequest(
        id,
        name.map(value => value),
        instanceCount.map(value => value),
        preferredInstanceType.map(value => value)
      )
    def id: ResourceId
    def name: Optional[OutpostResolverName]
    def instanceCount: Optional[InstanceCount]
    def preferredInstanceType: Optional[OutpostInstanceType]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, OutpostResolverName] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceCount: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getPreferredInstanceType: ZIO[Any, AwsError, OutpostInstanceType] =
      AwsError.unwrapOptionField("preferredInstanceType", preferredInstanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest
  ) extends zio.aws.route53resolver.model.UpdateOutpostResolverRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.id())
    override val name: Optional[OutpostResolverName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.route53resolver.model.primitives.OutpostResolverName(value)
      )
    override val instanceCount: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value =>
        zio.aws.route53resolver.model.primitives.InstanceCount(value)
      )
    override val preferredInstanceType: Optional[OutpostInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredInstanceType())
        .map(value =>
          zio.aws.route53resolver.model.primitives.OutpostInstanceType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest
  ): zio.aws.route53resolver.model.UpdateOutpostResolverRequest.ReadOnly =
    new Wrapper(impl)
}
