package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  MaxResults,
  OutpostArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListOutpostResolversRequest(
    outpostArn: Optional[OutpostArn] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest = {
    import ListOutpostResolversRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest
      .builder()
      .optionallyWith(
        outpostArn.map(value => OutpostArn.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListOutpostResolversRequest.ReadOnly =
    zio.aws.route53resolver.model.ListOutpostResolversRequest
      .wrap(buildAwsValue())
}
object ListOutpostResolversRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListOutpostResolversRequest =
      zio.aws.route53resolver.model.ListOutpostResolversRequest(
        outpostArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def outpostArn: Optional[OutpostArn]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getOutpostArn: ZIO[Any, AwsError, OutpostArn] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest
  ) extends zio.aws.route53resolver.model.ListOutpostResolversRequest.ReadOnly {
    override val outpostArn: Optional[OutpostArn] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => zio.aws.route53resolver.model.primitives.OutpostArn(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest
  ): zio.aws.route53resolver.model.ListOutpostResolversRequest.ReadOnly =
    new Wrapper(impl)
}
