package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisassociateResolverQueryLogConfigResponse(
    resolverQueryLogConfigAssociation: Optional[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse = {
    import DisassociateResolverQueryLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse
      .builder()
      .optionallyWith(
        resolverQueryLogConfigAssociation.map(value => value.buildAwsValue())
      )(_.resolverQueryLogConfigAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse
      .wrap(buildAwsValue())
}
object DisassociateResolverQueryLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse =
      zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse(
        resolverQueryLogConfigAssociation.map(value => value.asEditable)
      )
    def resolverQueryLogConfigAssociation: Optional[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]
    def getResolverQueryLogConfigAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resolverQueryLogConfigAssociation",
      resolverQueryLogConfigAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse
  ) extends zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly {
    override val resolverQueryLogConfigAssociation: Optional[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverQueryLogConfigAssociation())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse
  ): zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
