package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait ResolverEndpointDirection {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection
}
object ResolverEndpointDirection {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection
  ): zio.aws.route53resolver.model.ResolverEndpointDirection = value match {
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection.INBOUND =>
      val r = INBOUND
      r
    case software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection.OUTBOUND =>
      val r = OUTBOUND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.ResolverEndpointDirection {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection.UNKNOWN_TO_SDK_VERSION
  }
  case object INBOUND
      extends zio.aws.route53resolver.model.ResolverEndpointDirection {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection.INBOUND
  }
  case object OUTBOUND
      extends zio.aws.route53resolver.model.ResolverEndpointDirection {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection =
      software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection.OUTBOUND
  }
}
