package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  IpAddressCount,
  CreatorRequestId,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ResolverEndpoint(
    id: Optional[ResourceId] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    securityGroupIds: Optional[Iterable[ResourceId]] = Optional.Absent,
    direction: Optional[
      zio.aws.route53resolver.model.ResolverEndpointDirection
    ] = Optional.Absent,
    ipAddressCount: Optional[IpAddressCount] = Optional.Absent,
    hostVPCId: Optional[ResourceId] = Optional.Absent,
    status: Optional[zio.aws.route53resolver.model.ResolverEndpointStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    resolverEndpointType: Optional[
      zio.aws.route53resolver.model.ResolverEndpointType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint = {
    import ResolverEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(direction.map(value => value.unwrap))(_.direction)
      .optionallyWith(
        ipAddressCount.map(value => IpAddressCount.unwrap(value): Integer)
      )(_.ipAddressCount)
      .optionallyWith(
        hostVPCId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostVPCId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .optionallyWith(resolverEndpointType.map(value => value.unwrap))(
        _.resolverEndpointType
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly =
    zio.aws.route53resolver.model.ResolverEndpoint.wrap(buildAwsValue())
}
object ResolverEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverEndpoint =
      zio.aws.route53resolver.model.ResolverEndpoint(
        id.map(value => value),
        creatorRequestId.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        securityGroupIds.map(value => value),
        direction.map(value => value),
        ipAddressCount.map(value => value),
        hostVPCId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value),
        resolverEndpointType.map(value => value)
      )
    def id: Optional[ResourceId]
    def creatorRequestId: Optional[CreatorRequestId]
    def arn: Optional[Arn]
    def name: Optional[Name]
    def securityGroupIds: Optional[List[ResourceId]]
    def direction
        : Optional[zio.aws.route53resolver.model.ResolverEndpointDirection]
    def ipAddressCount: Optional[IpAddressCount]
    def hostVPCId: Optional[ResourceId]
    def status: Optional[zio.aws.route53resolver.model.ResolverEndpointStatus]
    def statusMessage: Optional[StatusMessage]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def resolverEndpointType
        : Optional[zio.aws.route53resolver.model.ResolverEndpointType]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getDirection: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpointDirection
    ] = AwsError.unwrapOptionField("direction", direction)
    def getIpAddressCount: ZIO[Any, AwsError, IpAddressCount] =
      AwsError.unwrapOptionField("ipAddressCount", ipAddressCount)
    def getHostVPCId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostVPCId", hostVPCId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpointStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
    def getResolverEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpointType
    ] = AwsError.unwrapOptionField("resolverEndpointType", resolverEndpointType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
  ) extends zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val securityGroupIds: Optional[List[ResourceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.primitives.ResourceId(item)
          }.toList
        )
    override val direction
        : Optional[zio.aws.route53resolver.model.ResolverEndpointDirection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.direction())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpointDirection.wrap(value)
        )
    override val ipAddressCount: Optional[IpAddressCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressCount())
        .map(value =>
          zio.aws.route53resolver.model.primitives.IpAddressCount(value)
        )
    override val hostVPCId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostVPCId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val status
        : Optional[zio.aws.route53resolver.model.ResolverEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpointStatus.wrap(value)
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val resolverEndpointType
        : Optional[zio.aws.route53resolver.model.ResolverEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverEndpointType())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpointType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
  ): zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly = new Wrapper(impl)
}
