package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResolverEndpointsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resolverEndpoints: Optional[
      Iterable[zio.aws.route53resolver.model.ResolverEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse = {
    import ListResolverEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resolverEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointsResponse
      .wrap(buildAwsValue())
}
object ListResolverEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverEndpointsResponse =
      zio.aws.route53resolver.model.ListResolverEndpointsResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resolverEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def resolverEndpoints: Optional[
      List[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResolverEndpoints: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("resolverEndpoints", resolverEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
  ) extends zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val resolverEndpoints: Optional[
      List[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
  ): zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
