package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Name, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateResolverEndpointRequest(
    resolverEndpointId: ResourceId,
    name: Optional[Name] = Optional.Absent,
    resolverEndpointType: Optional[
      zio.aws.route53resolver.model.ResolverEndpointType
    ] = Optional.Absent,
    updateIpAddresses: Optional[
      Iterable[zio.aws.route53resolver.model.UpdateIpAddress]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest = {
    import UpdateResolverEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(resolverEndpointType.map(value => value.unwrap))(
        _.resolverEndpointType
      )
      .optionallyWith(
        updateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updateIpAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverEndpointRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverEndpointRequest
      .wrap(buildAwsValue())
}
object UpdateResolverEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateResolverEndpointRequest =
      zio.aws.route53resolver.model.UpdateResolverEndpointRequest(
        resolverEndpointId,
        name.map(value => value),
        resolverEndpointType.map(value => value),
        updateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resolverEndpointId: ResourceId
    def name: Optional[Name]
    def resolverEndpointType
        : Optional[zio.aws.route53resolver.model.ResolverEndpointType]
    def updateIpAddresses
        : Optional[List[zio.aws.route53resolver.model.UpdateIpAddress.ReadOnly]]
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getResolverEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpointType
    ] = AwsError.unwrapOptionField("resolverEndpointType", resolverEndpointType)
    def getUpdateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.UpdateIpAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("updateIpAddresses", updateIpAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
  ) extends zio.aws.route53resolver.model.UpdateResolverEndpointRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val resolverEndpointType
        : Optional[zio.aws.route53resolver.model.ResolverEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverEndpointType())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpointType.wrap(value)
        )
    override val updateIpAddresses: Optional[
      List[zio.aws.route53resolver.model.UpdateIpAddress.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.UpdateIpAddress.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest
  ): zio.aws.route53resolver.model.UpdateResolverEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
