package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateOutpostResolverResponse(
    outpostResolver: Optional[zio.aws.route53resolver.model.OutpostResolver] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse = {
    import UpdateOutpostResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse
      .builder()
      .optionallyWith(outpostResolver.map(value => value.buildAwsValue()))(
        _.outpostResolver
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateOutpostResolverResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateOutpostResolverResponse
      .wrap(buildAwsValue())
}
object UpdateOutpostResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateOutpostResolverResponse =
      zio.aws.route53resolver.model.UpdateOutpostResolverResponse(
        outpostResolver.map(value => value.asEditable)
      )
    def outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly]
    def getOutpostResolver: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.OutpostResolver.ReadOnly
    ] = AwsError.unwrapOptionField("outpostResolver", outpostResolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse
  ) extends zio.aws.route53resolver.model.UpdateOutpostResolverResponse.ReadOnly {
    override val outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostResolver())
        .map(value => zio.aws.route53resolver.model.OutpostResolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse
  ): zio.aws.route53resolver.model.UpdateOutpostResolverResponse.ReadOnly =
    new Wrapper(impl)
}
