package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait RuleTypeOption {
  def unwrap
      : software.amazon.awssdk.services.route53resolver.model.RuleTypeOption
}
object RuleTypeOption {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.RuleTypeOption
  ): zio.aws.route53resolver.model.RuleTypeOption = value match {
    case software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.FORWARD =>
      val r = FORWARD
      r
    case software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.RECURSIVE =>
      val r = RECURSIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.RuleTypeOption {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.RuleTypeOption =
      software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.UNKNOWN_TO_SDK_VERSION
  }
  case object FORWARD extends zio.aws.route53resolver.model.RuleTypeOption {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.RuleTypeOption =
      software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.FORWARD
  }
  case object SYSTEM extends zio.aws.route53resolver.model.RuleTypeOption {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.RuleTypeOption =
      software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.SYSTEM
  }
  case object RECURSIVE extends zio.aws.route53resolver.model.RuleTypeOption {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.RuleTypeOption =
      software.amazon.awssdk.services.route53resolver.model.RuleTypeOption.RECURSIVE
  }
}
