package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{Count, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResolverQueryLogConfigAssociationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCount: Optional[Count] = Optional.Absent,
    totalFilteredCount: Optional[Count] = Optional.Absent,
    resolverQueryLogConfigAssociations: Optional[
      Iterable[zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse = {
    import ListResolverQueryLogConfigAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(totalCount.map(value => Count.unwrap(value): Integer))(
        _.totalCount
      )
      .optionallyWith(
        totalFilteredCount.map(value => Count.unwrap(value): Integer)
      )(_.totalFilteredCount)
      .optionallyWith(
        resolverQueryLogConfigAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverQueryLogConfigAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
      .wrap(buildAwsValue())
}
object ListResolverQueryLogConfigAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse =
      zio.aws.route53resolver.model
        .ListResolverQueryLogConfigAssociationsResponse(
          nextToken.map(value => value),
          totalCount.map(value => value),
          totalFilteredCount.map(value => value),
          resolverQueryLogConfigAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Optional[NextToken]
    def totalCount: Optional[Count]
    def totalFilteredCount: Optional[Count]
    def resolverQueryLogConfigAssociations: Optional[List[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getTotalFilteredCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("totalFilteredCount", totalFilteredCount)
    def getResolverQueryLogConfigAssociations: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resolverQueryLogConfigAssociations",
      resolverQueryLogConfigAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
  ) extends zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val totalCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.route53resolver.model.primitives.Count(value))
    override val totalFilteredCount: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.totalFilteredCount())
      .map(value => zio.aws.route53resolver.model.primitives.Count(value))
    override val resolverQueryLogConfigAssociations: Optional[List[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverQueryLogConfigAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse
  ): zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
