package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DeleteFirewallRuleRequest(
    firewallRuleGroupId: ResourceId,
    firewallDomainListId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest = {
    import DeleteFirewallRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest
      .builder()
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteFirewallRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteFirewallRuleRequest
      .wrap(buildAwsValue())
}
object DeleteFirewallRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.DeleteFirewallRuleRequest =
      zio.aws.route53resolver.model
        .DeleteFirewallRuleRequest(firewallRuleGroupId, firewallDomainListId)
    def firewallRuleGroupId: ResourceId
    def firewallDomainListId: ResourceId
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest
  ) extends zio.aws.route53resolver.model.DeleteFirewallRuleRequest.ReadOnly {
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest
  ): zio.aws.route53resolver.model.DeleteFirewallRuleRequest.ReadOnly =
    new Wrapper(impl)
}
