package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  MaxResults,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResolverEndpointIpAddressesRequest(
    resolverEndpointId: ResourceId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest = {
    import ListResolverEndpointIpAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest
      .wrap(buildAwsValue())
}
object ListResolverEndpointIpAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest =
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest(
        resolverEndpointId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resolverEndpointId: ResourceId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
  ) extends zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
  ): zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest.ReadOnly =
    new Wrapper(impl)
}
