package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  AccountId,
  Arn,
  Name,
  ResourceId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FirewallRuleGroupMetadata(
    id: Optional[ResourceId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    ownerId: Optional[AccountId] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    shareStatus: Optional[zio.aws.route53resolver.model.ShareStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata = {
    import FirewallRuleGroupMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(shareStatus.map(value => value.unwrap))(_.shareStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly =
    zio.aws.route53resolver.model.FirewallRuleGroupMetadata
      .wrap(buildAwsValue())
}
object FirewallRuleGroupMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallRuleGroupMetadata =
      zio.aws.route53resolver.model.FirewallRuleGroupMetadata(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        ownerId.map(value => value),
        creatorRequestId.map(value => value),
        shareStatus.map(value => value)
      )
    def id: Optional[ResourceId]
    def arn: Optional[Arn]
    def name: Optional[Name]
    def ownerId: Optional[AccountId]
    def creatorRequestId: Optional[CreatorRequestId]
    def shareStatus: Optional[zio.aws.route53resolver.model.ShareStatus]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getShareStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ShareStatus] =
      AwsError.unwrapOptionField("shareStatus", shareStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
  ) extends zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val ownerId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val shareStatus
        : Optional[zio.aws.route53resolver.model.ShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareStatus())
        .map(value => zio.aws.route53resolver.model.ShareStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
  ): zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly =
    new Wrapper(impl)
}
