package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.SortOrder
  ): zio.aws.route53resolver.model.SortOrder = value match {
    case software.amazon.awssdk.services.route53resolver.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.route53resolver.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.SortOrder =
      software.amazon.awssdk.services.route53resolver.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.route53resolver.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.SortOrder =
      software.amazon.awssdk.services.route53resolver.model.SortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.route53resolver.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.SortOrder =
      software.amazon.awssdk.services.route53resolver.model.SortOrder.DESCENDING
  }
}
