package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  StatusMessage,
  Name,
  ResourceId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResolverRuleAssociation(
    id: Optional[ResourceId] = Optional.Absent,
    resolverRuleId: Optional[ResourceId] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent,
    status: Optional[
      zio.aws.route53resolver.model.ResolverRuleAssociationStatus
    ] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation = {
    import ResolverRuleAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resolverRuleId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resolverRuleId)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly =
    zio.aws.route53resolver.model.ResolverRuleAssociation.wrap(buildAwsValue())
}
object ResolverRuleAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverRuleAssociation =
      zio.aws.route53resolver.model.ResolverRuleAssociation(
        id.map(value => value),
        resolverRuleId.map(value => value),
        name.map(value => value),
        vpcId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def id: Optional[ResourceId]
    def resolverRuleId: Optional[ResourceId]
    def name: Optional[Name]
    def vpcId: Optional[ResourceId]
    def status
        : Optional[zio.aws.route53resolver.model.ResolverRuleAssociationStatus]
    def statusMessage: Optional[StatusMessage]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getResolverRuleId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resolverRuleId", resolverRuleId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRuleAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
  ) extends zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resolverRuleId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverRuleId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val status: Optional[
      zio.aws.route53resolver.model.ResolverRuleAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.ResolverRuleAssociationStatus.wrap(value)
      )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
  ): zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly =
    new Wrapper(impl)
}
