package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait IpAddressStatus {
  def unwrap
      : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus
}
object IpAddressStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.IpAddressStatus
  ): zio.aws.route53resolver.model.IpAddressStatus = value match {
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.FAILED_CREATION =>
      val r = FAILED_CREATION
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.ATTACHING =>
      val r = ATTACHING
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.ATTACHED =>
      val r = ATTACHED
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.REMAP_DETACHING =>
      val r = REMAP_DETACHING
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.REMAP_ATTACHING =>
      val r = REMAP_ATTACHING
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.DETACHING =>
      val r = DETACHING
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.FAILED_RESOURCE_GONE =>
      val r = FAILED_RESOURCE_GONE
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.DELETE_FAILED_FAS_EXPIRED =>
      val r = DELETE_FAILED_FAS_EXPIRED
      r
    case software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.CREATING
  }
  case object FAILED_CREATION
      extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.FAILED_CREATION
  }
  case object ATTACHING extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.ATTACHING
  }
  case object ATTACHED extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.ATTACHED
  }
  case object REMAP_DETACHING
      extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.REMAP_DETACHING
  }
  case object REMAP_ATTACHING
      extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.REMAP_ATTACHING
  }
  case object DETACHING extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.DETACHING
  }
  case object FAILED_RESOURCE_GONE
      extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.FAILED_RESOURCE_GONE
  }
  case object DELETING extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.DELETING
  }
  case object DELETE_FAILED_FAS_EXPIRED
      extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.DELETE_FAILED_FAS_EXPIRED
  }
  case object UPDATING extends zio.aws.route53resolver.model.IpAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.IpAddressStatus =
      software.amazon.awssdk.services.route53resolver.model.IpAddressStatus.UPDATING
  }
}
