package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class UpdateResolverConfigRequest(
    resourceId: ResourceId,
    autodefinedReverseFlag: zio.aws.route53resolver.model.AutodefinedReverseFlag
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest = {
    import UpdateResolverConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .autodefinedReverseFlag(autodefinedReverseFlag.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverConfigRequest
      .wrap(buildAwsValue())
}
object UpdateResolverConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateResolverConfigRequest =
      zio.aws.route53resolver.model
        .UpdateResolverConfigRequest(resourceId, autodefinedReverseFlag)
    def resourceId: ResourceId
    def autodefinedReverseFlag
        : zio.aws.route53resolver.model.AutodefinedReverseFlag
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getAutodefinedReverseFlag: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.AutodefinedReverseFlag
    ] = ZIO.succeed(autodefinedReverseFlag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest
  ) extends zio.aws.route53resolver.model.UpdateResolverConfigRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resourceId())
    override val autodefinedReverseFlag
        : zio.aws.route53resolver.model.AutodefinedReverseFlag =
      zio.aws.route53resolver.model.AutodefinedReverseFlag
        .wrap(impl.autodefinedReverseFlag())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest
  ): zio.aws.route53resolver.model.UpdateResolverConfigRequest.ReadOnly =
    new Wrapper(impl)
}
