package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class GetResolverRulePolicyRequest(arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest = {
    import GetResolverRulePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverRulePolicyRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverRulePolicyRequest
      .wrap(buildAwsValue())
}
object GetResolverRulePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverRulePolicyRequest =
      zio.aws.route53resolver.model.GetResolverRulePolicyRequest(arn)
    def arn: Arn
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest
  ) extends zio.aws.route53resolver.model.GetResolverRulePolicyRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest
  ): zio.aws.route53resolver.model.GetResolverRulePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
