package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait BlockResponse {
  def unwrap
      : software.amazon.awssdk.services.route53resolver.model.BlockResponse
}
object BlockResponse {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.BlockResponse
  ): zio.aws.route53resolver.model.BlockResponse = value match {
    case software.amazon.awssdk.services.route53resolver.model.BlockResponse.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.BlockResponse.NODATA =>
      val r = NODATA
      r
    case software.amazon.awssdk.services.route53resolver.model.BlockResponse.NXDOMAIN =>
      val r = NXDOMAIN
      r
    case software.amazon.awssdk.services.route53resolver.model.BlockResponse.OVERRIDE =>
      val r = OVERRIDE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.BlockResponse {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.BlockResponse =
      software.amazon.awssdk.services.route53resolver.model.BlockResponse.UNKNOWN_TO_SDK_VERSION
  }
  case object NODATA extends zio.aws.route53resolver.model.BlockResponse {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.BlockResponse =
      software.amazon.awssdk.services.route53resolver.model.BlockResponse.NODATA
  }
  case object NXDOMAIN extends zio.aws.route53resolver.model.BlockResponse {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.BlockResponse =
      software.amazon.awssdk.services.route53resolver.model.BlockResponse.NXDOMAIN
  }
  case object OVERRIDE extends zio.aws.route53resolver.model.BlockResponse {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.BlockResponse =
      software.amazon.awssdk.services.route53resolver.model.BlockResponse.OVERRIDE
  }
}
