package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetFirewallRuleGroupAssociationRequest(
    firewallRuleGroupAssociationId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest = {
    import GetFirewallRuleGroupAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest
      .builder()
      .firewallRuleGroupAssociationId(
        ResourceId.unwrap(firewallRuleGroupAssociationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationRequest.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationRequest
      .wrap(buildAwsValue())
}
object GetFirewallRuleGroupAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationRequest =
      zio.aws.route53resolver.model
        .GetFirewallRuleGroupAssociationRequest(firewallRuleGroupAssociationId)
    def firewallRuleGroupAssociationId: ResourceId
    def getFirewallRuleGroupAssociationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest
  ) extends zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationRequest.ReadOnly {
    override val firewallRuleGroupAssociationId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest
  ): zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
