package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class UpdateResolverRuleRequest(
    resolverRuleId: ResourceId,
    config: zio.aws.route53resolver.model.ResolverRuleConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest = {
    import UpdateResolverRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest
      .builder()
      .resolverRuleId(ResourceId.unwrap(resolverRuleId): java.lang.String)
      .config(config.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverRuleRequest
      .wrap(buildAwsValue())
}
object UpdateResolverRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateResolverRuleRequest =
      zio.aws.route53resolver.model
        .UpdateResolverRuleRequest(resolverRuleId, config.asEditable)
    def resolverRuleId: ResourceId
    def config: zio.aws.route53resolver.model.ResolverRuleConfig.ReadOnly
    def getResolverRuleId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverRuleId)
    def getConfig: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.ResolverRuleConfig.ReadOnly
    ] = ZIO.succeed(config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest
  ) extends zio.aws.route53resolver.model.UpdateResolverRuleRequest.ReadOnly {
    override val resolverRuleId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resolverRuleId())
    override val config
        : zio.aws.route53resolver.model.ResolverRuleConfig.ReadOnly =
      zio.aws.route53resolver.model.ResolverRuleConfig.wrap(impl.config())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest
  ): zio.aws.route53resolver.model.UpdateResolverRuleRequest.ReadOnly =
    new Wrapper(impl)
}
