package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListResolverConfigsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    resolverConfigs: Optional[
      Iterable[zio.aws.route53resolver.model.ResolverConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse = {
    import ListResolverConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        resolverConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverConfigsResponse
      .wrap(buildAwsValue())
}
object ListResolverConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverConfigsResponse =
      zio.aws.route53resolver.model.ListResolverConfigsResponse(
        nextToken.map(value => value),
        resolverConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def resolverConfigs
        : Optional[List[zio.aws.route53resolver.model.ResolverConfig.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResolverConfigs: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("resolverConfigs", resolverConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
  ) extends zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val resolverConfigs: Optional[
      List[zio.aws.route53resolver.model.ResolverConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
  ): zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
