package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{AccountId, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResolverDnssecConfig(
    id: Optional[ResourceId] = Optional.Absent,
    ownerId: Optional[AccountId] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    validationStatus: Optional[
      zio.aws.route53resolver.model.ResolverDNSSECValidationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig = {
    import ResolverDnssecConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly =
    zio.aws.route53resolver.model.ResolverDnssecConfig.wrap(buildAwsValue())
}
object ResolverDnssecConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverDnssecConfig =
      zio.aws.route53resolver.model.ResolverDnssecConfig(
        id.map(value => value),
        ownerId.map(value => value),
        resourceId.map(value => value),
        validationStatus.map(value => value)
      )
    def id: Optional[ResourceId]
    def ownerId: Optional[AccountId]
    def resourceId: Optional[ResourceId]
    def validationStatus
        : Optional[zio.aws.route53resolver.model.ResolverDNSSECValidationStatus]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getValidationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverDNSSECValidationStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
  ) extends zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val ownerId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val validationStatus: Optional[
      zio.aws.route53resolver.model.ResolverDNSSECValidationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationStatus())
      .map(value =>
        zio.aws.route53resolver.model.ResolverDNSSECValidationStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
  ): zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly = new Wrapper(
    impl
  )
}
