package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetResolverRuleAssociationRequest(
    resolverRuleAssociationId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest = {
    import GetResolverRuleAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest
      .builder()
      .resolverRuleAssociationId(
        ResourceId.unwrap(resolverRuleAssociationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverRuleAssociationRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverRuleAssociationRequest
      .wrap(buildAwsValue())
}
object GetResolverRuleAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverRuleAssociationRequest =
      zio.aws.route53resolver.model
        .GetResolverRuleAssociationRequest(resolverRuleAssociationId)
    def resolverRuleAssociationId: ResourceId
    def getResolverRuleAssociationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverRuleAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest
  ) extends zio.aws.route53resolver.model.GetResolverRuleAssociationRequest.ReadOnly {
    override val resolverRuleAssociationId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverRuleAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest
  ): zio.aws.route53resolver.model.GetResolverRuleAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
