package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Ip, SubnetId, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IpAddressUpdate(
    ipId: Optional[ResourceId] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    ip: Optional[Ip] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.IpAddressUpdate = {
    import IpAddressUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.IpAddressUpdate
      .builder()
      .optionallyWith(
        ipId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.ipId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(ip.map(value => Ip.unwrap(value): java.lang.String))(_.ip)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.IpAddressUpdate.ReadOnly =
    zio.aws.route53resolver.model.IpAddressUpdate.wrap(buildAwsValue())
}
object IpAddressUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.IpAddressUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.IpAddressUpdate =
      zio.aws.route53resolver.model.IpAddressUpdate(
        ipId.map(value => value),
        subnetId.map(value => value),
        ip.map(value => value)
      )
    def ipId: Optional[ResourceId]
    def subnetId: Optional[SubnetId]
    def ip: Optional[Ip]
    def getIpId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("ipId", ipId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getIp: ZIO[Any, AwsError, Ip] = AwsError.unwrapOptionField("ip", ip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressUpdate
  ) extends zio.aws.route53resolver.model.IpAddressUpdate.ReadOnly {
    override val ipId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.route53resolver.model.primitives.SubnetId(value))
    override val ip: Optional[Ip] = zio.aws.core.internal
      .optionalFromNullable(impl.ip())
      .map(value => zio.aws.route53resolver.model.primitives.Ip(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressUpdate
  ): zio.aws.route53resolver.model.IpAddressUpdate.ReadOnly = new Wrapper(impl)
}
