package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFirewallDomainListResponse(
    firewallDomainList: Optional[
      zio.aws.route53resolver.model.FirewallDomainList
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse = {
    import GetFirewallDomainListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse
      .builder()
      .optionallyWith(firewallDomainList.map(value => value.buildAwsValue()))(
        _.firewallDomainList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallDomainListResponse
      .wrap(buildAwsValue())
}
object GetFirewallDomainListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetFirewallDomainListResponse =
      zio.aws.route53resolver.model.GetFirewallDomainListResponse(
        firewallDomainList.map(value => value.asEditable)
      )
    def firewallDomainList
        : Optional[zio.aws.route53resolver.model.FirewallDomainList.ReadOnly]
    def getFirewallDomainList: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainList.ReadOnly
    ] = AwsError.unwrapOptionField("firewallDomainList", firewallDomainList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse
  ) extends zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly {
    override val firewallDomainList
        : Optional[zio.aws.route53resolver.model.FirewallDomainList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallDomainList())
        .map(value =>
          zio.aws.route53resolver.model.FirewallDomainList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse
  ): zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly =
    new Wrapper(impl)
}
