package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFirewallRuleGroupResponse(
    firewallRuleGroup: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse = {
    import DeleteFirewallRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse
      .builder()
      .optionallyWith(firewallRuleGroup.map(value => value.buildAwsValue()))(
        _.firewallRuleGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse
      .wrap(buildAwsValue())
}
object DeleteFirewallRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse =
      zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse(
        firewallRuleGroup.map(value => value.asEditable)
      )
    def firewallRuleGroup
        : Optional[zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly]
    def getFirewallRuleGroup: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly
    ] = AwsError.unwrapOptionField("firewallRuleGroup", firewallRuleGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse
  ) extends zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse.ReadOnly {
    override val firewallRuleGroup
        : Optional[zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRuleGroup())
        .map(value =>
          zio.aws.route53resolver.model.FirewallRuleGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse
  ): zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
