package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateFirewallRuleGroupResponse(
    firewallRuleGroupAssociation: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse = {
    import AssociateFirewallRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse
      .builder()
      .optionallyWith(
        firewallRuleGroupAssociation.map(value => value.buildAwsValue())
      )(_.firewallRuleGroupAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly =
    zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse
      .wrap(buildAwsValue())
}
object AssociateFirewallRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse =
      zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse(
        firewallRuleGroupAssociation.map(value => value.asEditable)
      )
    def firewallRuleGroupAssociation: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ]
    def getFirewallRuleGroupAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "firewallRuleGroupAssociation",
      firewallRuleGroupAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse
  ) extends zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly {
    override val firewallRuleGroupAssociation: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallRuleGroupAssociation())
      .map(value =>
        zio.aws.route53resolver.model.FirewallRuleGroupAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse
  ): zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
