package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  Priority,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage,
  ServicePrinciple
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FirewallRuleGroupAssociation(
    id: Optional[ResourceId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    firewallRuleGroupId: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    priority: Optional[Priority] = Optional.Absent,
    mutationProtection: Optional[
      zio.aws.route53resolver.model.MutationProtectionStatus
    ] = Optional.Absent,
    managedOwnerName: Optional[ServicePrinciple] = Optional.Absent,
    status: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation = {
    import FirewallRuleGroupAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        firewallRuleGroupId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallRuleGroupId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(mutationProtection.map(value => value.unwrap))(
        _.mutationProtection
      )
      .optionallyWith(
        managedOwnerName.map(value =>
          ServicePrinciple.unwrap(value): java.lang.String
        )
      )(_.managedOwnerName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly =
    zio.aws.route53resolver.model.FirewallRuleGroupAssociation
      .wrap(buildAwsValue())
}
object FirewallRuleGroupAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallRuleGroupAssociation =
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation(
        id.map(value => value),
        arn.map(value => value),
        firewallRuleGroupId.map(value => value),
        vpcId.map(value => value),
        name.map(value => value),
        priority.map(value => value),
        mutationProtection.map(value => value),
        managedOwnerName.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creatorRequestId.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def id: Optional[ResourceId]
    def arn: Optional[Arn]
    def firewallRuleGroupId: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def name: Optional[Name]
    def priority: Optional[Priority]
    def mutationProtection
        : Optional[zio.aws.route53resolver.model.MutationProtectionStatus]
    def managedOwnerName: Optional[ServicePrinciple]
    def status: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ]
    def statusMessage: Optional[StatusMessage]
    def creatorRequestId: Optional[CreatorRequestId]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getFirewallRuleGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallRuleGroupId", firewallRuleGroupId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMutationProtection: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.MutationProtectionStatus
    ] = AwsError.unwrapOptionField("mutationProtection", mutationProtection)
    def getManagedOwnerName: ZIO[Any, AwsError, ServicePrinciple] =
      AwsError.unwrapOptionField("managedOwnerName", managedOwnerName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation
  ) extends zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val firewallRuleGroupId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRuleGroupId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ResourceId(value)
        )
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.route53resolver.model.primitives.Priority(value))
    override val mutationProtection
        : Optional[zio.aws.route53resolver.model.MutationProtectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mutationProtection())
        .map(value =>
          zio.aws.route53resolver.model.MutationProtectionStatus.wrap(value)
        )
    override val managedOwnerName: Optional[ServicePrinciple] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedOwnerName())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ServicePrinciple(value)
        )
    override val status: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus
          .wrap(value)
      )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation
  ): zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly =
    new Wrapper(impl)
}
