package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetResolverConfigRequest(resourceId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest = {
    import GetResolverConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverConfigRequest.wrap(buildAwsValue())
}
object GetResolverConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverConfigRequest =
      zio.aws.route53resolver.model.GetResolverConfigRequest(resourceId)
    def resourceId: ResourceId
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest
  ) extends zio.aws.route53resolver.model.GetResolverConfigRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest
  ): zio.aws.route53resolver.model.GetResolverConfigRequest.ReadOnly =
    new Wrapper(impl)
}
