package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  Arn,
  Name,
  ResourceId,
  ServicePrinciple
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FirewallDomainListMetadata(
    id: Optional[ResourceId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    managedOwnerName: Optional[ServicePrinciple] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata = {
    import FirewallDomainListMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        managedOwnerName.map(value =>
          ServicePrinciple.unwrap(value): java.lang.String
        )
      )(_.managedOwnerName)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly =
    zio.aws.route53resolver.model.FirewallDomainListMetadata
      .wrap(buildAwsValue())
}
object FirewallDomainListMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallDomainListMetadata =
      zio.aws.route53resolver.model.FirewallDomainListMetadata(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        creatorRequestId.map(value => value),
        managedOwnerName.map(value => value)
      )
    def id: Optional[ResourceId]
    def arn: Optional[Arn]
    def name: Optional[Name]
    def creatorRequestId: Optional[CreatorRequestId]
    def managedOwnerName: Optional[ServicePrinciple]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getManagedOwnerName: ZIO[Any, AwsError, ServicePrinciple] =
      AwsError.unwrapOptionField("managedOwnerName", managedOwnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
  ) extends zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val managedOwnerName: Optional[ServicePrinciple] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedOwnerName())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ServicePrinciple(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
  ): zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly =
    new Wrapper(impl)
}
