package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateResolverRuleResponse(
    resolverRuleAssociation: Optional[
      zio.aws.route53resolver.model.ResolverRuleAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse = {
    import AssociateResolverRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse
      .builder()
      .optionallyWith(
        resolverRuleAssociation.map(value => value.buildAwsValue())
      )(_.resolverRuleAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.AssociateResolverRuleResponse
      .wrap(buildAwsValue())
}
object AssociateResolverRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.AssociateResolverRuleResponse =
      zio.aws.route53resolver.model.AssociateResolverRuleResponse(
        resolverRuleAssociation.map(value => value.asEditable)
      )
    def resolverRuleAssociation: Optional[
      zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
    ]
    def getResolverRuleAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resolverRuleAssociation",
      resolverRuleAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse
  ) extends zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly {
    override val resolverRuleAssociation: Optional[
      zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverRuleAssociation())
      .map(value =>
        zio.aws.route53resolver.model.ResolverRuleAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse
  ): zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly =
    new Wrapper(impl)
}
