package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  AccountId,
  DomainName,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResolverRule(
    id: Optional[ResourceId] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    status: Optional[zio.aws.route53resolver.model.ResolverRuleStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    ruleType: Optional[zio.aws.route53resolver.model.RuleTypeOption] =
      Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    targetIps: Optional[Iterable[zio.aws.route53resolver.model.TargetAddress]] =
      Optional.Absent,
    resolverEndpointId: Optional[ResourceId] = Optional.Absent,
    ownerId: Optional[AccountId] = Optional.Absent,
    shareStatus: Optional[zio.aws.route53resolver.model.ShareStatus] =
      Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverRule = {
    import ResolverRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverRule
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(ruleType.map(value => value.unwrap))(_.ruleType)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        targetIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetIps)
      .optionallyWith(
        resolverEndpointId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.resolverEndpointId)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(shareStatus.map(value => value.unwrap))(_.shareStatus)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverRule.ReadOnly =
    zio.aws.route53resolver.model.ResolverRule.wrap(buildAwsValue())
}
object ResolverRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverRule =
      zio.aws.route53resolver.model.ResolverRule(
        id.map(value => value),
        creatorRequestId.map(value => value),
        arn.map(value => value),
        domainName.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        ruleType.map(value => value),
        name.map(value => value),
        targetIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resolverEndpointId.map(value => value),
        ownerId.map(value => value),
        shareStatus.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def id: Optional[ResourceId]
    def creatorRequestId: Optional[CreatorRequestId]
    def arn: Optional[Arn]
    def domainName: Optional[DomainName]
    def status: Optional[zio.aws.route53resolver.model.ResolverRuleStatus]
    def statusMessage: Optional[StatusMessage]
    def ruleType: Optional[zio.aws.route53resolver.model.RuleTypeOption]
    def name: Optional[Name]
    def targetIps
        : Optional[List[zio.aws.route53resolver.model.TargetAddress.ReadOnly]]
    def resolverEndpointId: Optional[ResourceId]
    def ownerId: Optional[AccountId]
    def shareStatus: Optional[zio.aws.route53resolver.model.ShareStatus]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ResolverRuleStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getRuleType
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.RuleTypeOption] =
      AwsError.unwrapOptionField("ruleType", ruleType)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getTargetIps: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.TargetAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("targetIps", targetIps)
    def getResolverEndpointId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resolverEndpointId", resolverEndpointId)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getShareStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ShareStatus] =
      AwsError.unwrapOptionField("shareStatus", shareStatus)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRule
  ) extends zio.aws.route53resolver.model.ResolverRule.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.route53resolver.model.primitives.DomainName(value))
    override val status
        : Optional[zio.aws.route53resolver.model.ResolverRuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.ResolverRuleStatus.wrap(value)
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val ruleType
        : Optional[zio.aws.route53resolver.model.RuleTypeOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleType())
        .map(value => zio.aws.route53resolver.model.RuleTypeOption.wrap(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val targetIps
        : Optional[List[zio.aws.route53resolver.model.TargetAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetIps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.TargetAddress.wrap(item)
          }.toList
        )
    override val resolverEndpointId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverEndpointId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ResourceId(value)
        )
    override val ownerId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val shareStatus
        : Optional[zio.aws.route53resolver.model.ShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareStatus())
        .map(value => zio.aws.route53resolver.model.ShareStatus.wrap(value))
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRule
  ): zio.aws.route53resolver.model.ResolverRule.ReadOnly = new Wrapper(impl)
}
