package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait AutodefinedReverseFlag {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag
}
object AutodefinedReverseFlag {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag
  ): zio.aws.route53resolver.model.AutodefinedReverseFlag = value match {
    case software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag.DISABLE =>
      val r = DISABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.AutodefinedReverseFlag {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag =
      software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE
      extends zio.aws.route53resolver.model.AutodefinedReverseFlag {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag =
      software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag.ENABLE
  }
  case object DISABLE
      extends zio.aws.route53resolver.model.AutodefinedReverseFlag {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag =
      software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag.DISABLE
  }
}
