package zio.aws.route53resolver
import zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse.ReadOnly
import software.amazon.awssdk.services.route53resolver.{
  Route53ResolverAsyncClientBuilder,
  Route53ResolverAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.route53resolver.model.{
  DeleteFirewallDomainListRequest,
  AssociateResolverRuleRequest,
  ListFirewallConfigsRequest,
  DeleteResolverEndpointRequest,
  GetResolverQueryLogConfigPolicyRequest,
  UpdateFirewallDomainsRequest,
  ListFirewallDomainsRequest,
  ListResolverEndpointsRequest,
  AssociateResolverEndpointIpAddressRequest,
  AssociateFirewallRuleGroupRequest,
  ListFirewallRulesRequest,
  GetResolverRulePolicyRequest,
  GetResolverConfigRequest,
  ListResolverEndpointIpAddressesRequest,
  DisassociateResolverQueryLogConfigRequest,
  UpdateResolverConfigRequest,
  PutFirewallRuleGroupPolicyRequest,
  ListResolverQueryLogConfigAssociationsRequest,
  PutResolverRulePolicyRequest,
  DisassociateResolverEndpointIpAddressRequest,
  CreateResolverQueryLogConfigRequest,
  DisassociateFirewallRuleGroupRequest,
  GetResolverQueryLogConfigAssociationRequest,
  ListTagsForResourceRequest,
  PutResolverQueryLogConfigPolicyRequest,
  ListFirewallRuleGroupsRequest,
  DeleteResolverRuleRequest,
  UpdateResolverEndpointRequest,
  GetResolverEndpointRequest,
  CreateResolverEndpointRequest,
  UpdateFirewallRuleGroupAssociationRequest,
  GetResolverRuleAssociationRequest,
  ListResolverConfigsRequest,
  UpdateFirewallRuleRequest,
  ImportFirewallDomainsRequest,
  ListFirewallRuleGroupAssociationsRequest,
  GetFirewallRuleGroupPolicyRequest,
  GetResolverDnssecConfigRequest,
  ListResolverRuleAssociationsRequest,
  CreateFirewallRuleRequest,
  DeleteFirewallRuleRequest,
  DeleteFirewallRuleGroupRequest,
  CreateFirewallDomainListRequest,
  UntagResourceRequest,
  DisassociateResolverRuleRequest,
  ListFirewallDomainListsRequest,
  CreateFirewallRuleGroupRequest,
  UpdateResolverDnssecConfigRequest,
  AssociateResolverQueryLogConfigRequest,
  GetFirewallConfigRequest,
  ListResolverRulesRequest,
  ListResolverQueryLogConfigsRequest,
  UpdateFirewallConfigRequest,
  GetFirewallDomainListRequest,
  GetFirewallRuleGroupAssociationRequest,
  GetResolverRuleRequest,
  TagResourceRequest,
  CreateResolverRuleRequest,
  GetResolverQueryLogConfigRequest,
  GetFirewallRuleGroupRequest,
  ListResolverDnssecConfigsRequest,
  DeleteResolverQueryLogConfigRequest,
  UpdateResolverRuleRequest
}
import zio.aws.route53resolver.model.primitives.FirewallDomainName
import software.amazon.awssdk.services.route53resolver.model.{
  ListResolverQueryLogConfigAssociationsResponse,
  ResolverDnssecConfig,
  FirewallDomainListMetadata,
  GetFirewallRuleGroupPolicyResponse,
  GetResolverQueryLogConfigResponse,
  ListFirewallRuleGroupAssociationsResponse,
  ResolverConfig,
  ListFirewallRuleGroupsResponse,
  AssociateResolverEndpointIpAddressResponse,
  IpAddressResponse,
  DeleteFirewallDomainListResponse,
  ResolverQueryLogConfigAssociation,
  GetFirewallRuleGroupAssociationResponse,
  ResolverEndpoint,
  CreateFirewallRuleGroupResponse,
  DisassociateFirewallRuleGroupResponse,
  ImportFirewallDomainsResponse,
  UpdateFirewallConfigResponse,
  ListFirewallRulesResponse,
  UpdateResolverRuleResponse,
  DeleteFirewallRuleGroupResponse,
  DisassociateResolverRuleResponse,
  FirewallRuleGroupAssociation,
  GetResolverRuleResponse,
  PutResolverQueryLogConfigPolicyResponse,
  Tag,
  UpdateResolverEndpointResponse,
  UpdateResolverConfigResponse,
  ResolverQueryLogConfig,
  ResolverRule,
  AssociateResolverQueryLogConfigResponse,
  GetFirewallConfigResponse,
  ListResolverDnssecConfigsResponse,
  GetResolverRulePolicyResponse,
  ListTagsForResourceResponse,
  CreateResolverEndpointResponse,
  UntagResourceResponse,
  CreateFirewallDomainListResponse,
  AssociateFirewallRuleGroupResponse,
  PutFirewallRuleGroupPolicyResponse,
  GetResolverConfigResponse,
  ResolverRuleAssociation,
  DisassociateResolverEndpointIpAddressResponse,
  GetResolverEndpointResponse,
  ListResolverRulesResponse,
  ListResolverQueryLogConfigsResponse,
  FirewallRuleGroupMetadata,
  UpdateFirewallDomainsResponse,
  DeleteResolverRuleResponse,
  CreateResolverRuleResponse,
  FirewallConfig,
  GetResolverQueryLogConfigAssociationResponse,
  AssociateResolverRuleResponse,
  ListResolverRuleAssociationsResponse,
  UpdateResolverDnssecConfigResponse,
  ListFirewallDomainListsResponse,
  DisassociateResolverQueryLogConfigResponse,
  ListFirewallConfigsResponse,
  CreateFirewallRuleResponse,
  ListResolverConfigsResponse,
  UpdateFirewallRuleGroupAssociationResponse,
  GetFirewallDomainListResponse,
  CreateResolverQueryLogConfigResponse,
  DeleteFirewallRuleResponse,
  GetFirewallRuleGroupResponse,
  DeleteResolverEndpointResponse,
  TagResourceResponse,
  GetResolverDnssecConfigResponse,
  DeleteResolverQueryLogConfigResponse,
  GetResolverQueryLogConfigPolicyResponse,
  ListFirewallDomainsResponse,
  UpdateFirewallRuleResponse,
  GetResolverRuleAssociationResponse,
  PutResolverRulePolicyResponse,
  FirewallRule,
  ListResolverEndpointIpAddressesResponse,
  ListResolverEndpointsResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Route53Resolver extends AspectSupport[Route53Resolver] {
  val api: Route53ResolverAsyncClient
  def updateFirewallConfig(request: UpdateFirewallConfigRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly
  ]
  def deleteFirewallRuleGroup(
      request: DeleteFirewallRuleGroupRequest
  ): IO[AwsError, ReadOnly]
  def listFirewallDomainLists(request: ListFirewallDomainListsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly
  ]
  def listFirewallDomainListsPaginated(
      request: ListFirewallDomainListsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly
  ]
  def deleteResolverQueryLogConfig(
      request: DeleteResolverQueryLogConfigRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly
  ]
  def getResolverQueryLogConfig(request: GetResolverQueryLogConfigRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly
  ]
  def createFirewallRule(request: CreateFirewallRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.CreateFirewallRuleResponse.ReadOnly
  ]
  def updateResolverConfig(request: UpdateResolverConfigRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly
  ]
  def listResolverEndpointIpAddresses(
      request: ListResolverEndpointIpAddressesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly,
    zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
  ]]
  def listResolverEndpointIpAddressesPaginated(
      request: ListResolverEndpointIpAddressesRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly
  ]
  def listResolverEndpoints(
      request: ListResolverEndpointsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly,
    zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
  ]]
  def listResolverEndpointsPaginated(request: ListResolverEndpointsRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly
  ]
  def listResolverRules(
      request: ListResolverRulesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly,
    zio.aws.route53resolver.model.ResolverRule.ReadOnly
  ]]
  def listResolverRulesPaginated(request: ListResolverRulesRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly
  ]
  def deleteFirewallRule(request: DeleteFirewallRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly
  ]
  def associateResolverQueryLogConfig(
      request: AssociateResolverQueryLogConfigRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.AssociateResolverQueryLogConfigResponse.ReadOnly
  ]
  def listFirewallDomains(
      request: ListFirewallDomainsRequest
  ): ZStream[Any, AwsError, FirewallDomainName]
  def listFirewallDomainsPaginated(request: ListFirewallDomainsRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly
  ]
  def getFirewallDomainList(request: GetFirewallDomainListRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly
  ]
  def createFirewallRuleGroup(request: CreateFirewallRuleGroupRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.CreateFirewallRuleGroupResponse.ReadOnly
  ]
  def disassociateResolverEndpointIpAddress(
      request: DisassociateResolverEndpointIpAddressRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.DisassociateResolverEndpointIpAddressResponse.ReadOnly
  ]
  def updateResolverRule(request: UpdateResolverRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly
  ]
  def createResolverEndpoint(request: CreateResolverEndpointRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.CreateResolverEndpointResponse.ReadOnly
  ]
  def listResolverRuleAssociations(
      request: ListResolverRuleAssociationsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly,
    zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
  ]]
  def listResolverRuleAssociationsPaginated(
      request: ListResolverRuleAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly
  ]
  def updateResolverEndpoint(request: UpdateResolverEndpointRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly
  ]
  def putResolverRulePolicy(request: PutResolverRulePolicyRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly
  ]
  def getFirewallRuleGroupPolicy(
      request: GetFirewallRuleGroupPolicyRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly
  ]
  def getResolverRuleAssociation(
      request: GetResolverRuleAssociationRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverRuleAssociationResponse.ReadOnly
  ]
  def disassociateFirewallRuleGroup(
      request: DisassociateFirewallRuleGroupRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.DisassociateFirewallRuleGroupResponse.ReadOnly
  ]
  def associateFirewallRuleGroup(
      request: AssociateFirewallRuleGroupRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly
  ]
  def disassociateResolverRule(request: DisassociateResolverRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.DisassociateResolverRuleResponse.ReadOnly
  ]
  def getResolverDnssecConfig(request: GetResolverDnssecConfigRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly
  ]
  def listResolverDnssecConfigs(
      request: ListResolverDnssecConfigsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
  ]
  def listResolverDnssecConfigsPaginated(
      request: ListResolverDnssecConfigsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly
  ]
  def getResolverRule(request: GetResolverRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly
  ]
  def disassociateResolverQueryLogConfig(
      request: DisassociateResolverQueryLogConfigRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly
  ]
  def listFirewallConfigs(request: ListFirewallConfigsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53resolver.model.FirewallConfig.ReadOnly
  ]
  def listFirewallConfigsPaginated(request: ListFirewallConfigsRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly
  ]
  def updateFirewallRuleGroupAssociation(
      request: UpdateFirewallRuleGroupAssociationRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly
  ]
  def updateFirewallDomains(request: UpdateFirewallDomainsRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly
  ]
  def getResolverRulePolicy(request: GetResolverRulePolicyRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly
  ]
  def createResolverQueryLogConfig(
      request: CreateResolverQueryLogConfigRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly
  ]
  def deleteFirewallDomainList(request: DeleteFirewallDomainListRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly
  ]
  def getResolverEndpoint(request: GetResolverEndpointRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.route53resolver.model.UntagResourceResponse.ReadOnly]
  def getResolverQueryLogConfigAssociation(
      request: GetResolverQueryLogConfigAssociationRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly
  ]
  def listResolverConfigs(request: ListResolverConfigsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53resolver.model.ResolverConfig.ReadOnly
  ]
  def listResolverConfigsPaginated(request: ListResolverConfigsRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly
  ]
  def listResolverQueryLogConfigs(
      request: ListResolverQueryLogConfigsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly,
    zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
  ]]
  def listResolverQueryLogConfigsPaginated(
      request: ListResolverQueryLogConfigsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly
  ]
  def listResolverQueryLogConfigAssociations(
      request: ListResolverQueryLogConfigAssociationsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly,
    zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
  ]]
  def listResolverQueryLogConfigAssociationsPaginated(
      request: ListResolverQueryLogConfigAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly
  ]
  def putFirewallRuleGroupPolicy(
      request: PutFirewallRuleGroupPolicyRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.route53resolver.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListTagsForResourceResponse.ReadOnly
  ]
  def getFirewallRuleGroupAssociation(
      request: GetFirewallRuleGroupAssociationRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationResponse.ReadOnly
  ]
  def associateResolverEndpointIpAddress(
      request: AssociateResolverEndpointIpAddressRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.route53resolver.model.TagResourceResponse.ReadOnly]
  def importFirewallDomains(request: ImportFirewallDomainsRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly
  ]
  def deleteResolverEndpoint(request: DeleteResolverEndpointRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly
  ]
  def listFirewallRuleGroupAssociations(
      request: ListFirewallRuleGroupAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
  ]
  def listFirewallRuleGroupAssociationsPaginated(
      request: ListFirewallRuleGroupAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly
  ]
  def listFirewallRules(
      request: ListFirewallRulesRequest
  ): ZStream[Any, AwsError, zio.aws.route53resolver.model.FirewallRule.ReadOnly]
  def listFirewallRulesPaginated(request: ListFirewallRulesRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly
  ]
  def listFirewallRuleGroups(request: ListFirewallRuleGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly
  ]
  def listFirewallRuleGroupsPaginated(
      request: ListFirewallRuleGroupsRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly
  ]
  def deleteResolverRule(request: DeleteResolverRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly
  ]
  def getResolverConfig(request: GetResolverConfigRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly
  ]
  def updateFirewallRule(request: UpdateFirewallRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly
  ]
  def getResolverQueryLogConfigPolicy(
      request: GetResolverQueryLogConfigPolicyRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly
  ]
  def createFirewallDomainList(request: CreateFirewallDomainListRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly
  ]
  def getFirewallConfig(request: GetFirewallConfigRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly
  ]
  def updateResolverDnssecConfig(
      request: UpdateResolverDnssecConfigRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly
  ]
  def associateResolverRule(request: AssociateResolverRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly
  ]
  def createResolverRule(request: CreateResolverRuleRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly
  ]
  def putResolverQueryLogConfigPolicy(
      request: PutResolverQueryLogConfigPolicyRequest
  ): IO[
    AwsError,
    zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly
  ]
  def getFirewallRuleGroup(request: GetFirewallRuleGroupRequest): IO[
    AwsError,
    zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly
  ]
}
object Route53Resolver {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Route53Resolver] =
    customized(identity)
  def customized(
      customization: Route53ResolverAsyncClientBuilder => Route53ResolverAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Route53Resolver] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Route53ResolverAsyncClientBuilder => Route53ResolverAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Route53Resolver] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Route53ResolverAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[Route53ResolverAsyncClient, Route53ResolverAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      Route53ResolverAsyncClient,
      Route53ResolverAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new Route53ResolverImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class Route53ResolverImpl[R](
      override val api: Route53ResolverAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Route53Resolver
      with AwsServiceBase[R] {
    override val serviceName: String = "Route53Resolver"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Route53ResolverImpl[R1] = new Route53ResolverImpl(api, newAspect, r)
    def updateFirewallConfig(request: UpdateFirewallConfigRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest,
      UpdateFirewallConfigResponse
    ]("updateFirewallConfig", api.updateFirewallConfig)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.UpdateFirewallConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteFirewallRuleGroup(
        request: DeleteFirewallRuleGroupRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest,
      DeleteFirewallRuleGroupResponse
    ]("deleteFirewallRuleGroup", api.deleteFirewallRuleGroup)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.DeleteFirewallRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def listFirewallDomainLists(
        request: ListFirewallDomainListsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest,
      ListFirewallDomainListsResponse,
      FirewallDomainListMetadata
    ](
      "listFirewallDomainLists",
      api.listFirewallDomainLists,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewallDomainLists().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53resolver.model.FirewallDomainListMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listFirewallDomainListsPaginated(
        request: ListFirewallDomainListsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest,
      ListFirewallDomainListsResponse
    ]("listFirewallDomainLists", api.listFirewallDomainLists)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.ListFirewallDomainListsResponse.wrap)
      .provideEnvironment(r)
    def deleteResolverQueryLogConfig(
        request: DeleteResolverQueryLogConfigRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest,
      DeleteResolverQueryLogConfigResponse
    ]("deleteResolverQueryLogConfig", api.deleteResolverQueryLogConfig)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.wrap
    ).provideEnvironment(r)
    def getResolverQueryLogConfig(
        request: GetResolverQueryLogConfigRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest,
      GetResolverQueryLogConfigResponse
    ]("getResolverQueryLogConfig", api.getResolverQueryLogConfig)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.wrap)
      .provideEnvironment(r)
    def createFirewallRule(request: CreateFirewallRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.CreateFirewallRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest,
      CreateFirewallRuleResponse
    ]("createFirewallRule", api.createFirewallRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.CreateFirewallRuleResponse.wrap)
      .provideEnvironment(r)
    def updateResolverConfig(request: UpdateResolverConfigRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest,
      UpdateResolverConfigResponse
    ]("updateResolverConfig", api.updateResolverConfig)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.UpdateResolverConfigResponse.wrap)
      .provideEnvironment(r)
    def listResolverEndpointIpAddresses(
        request: ListResolverEndpointIpAddressesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly,
      zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest,
      ListResolverEndpointIpAddressesResponse,
      IpAddressResponse
    ](
      "listResolverEndpointIpAddresses",
      api.listResolverEndpointIpAddresses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.ipAddresses().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.route53resolver.model.IpAddressResponse.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResolverEndpointIpAddressesPaginated(
        request: ListResolverEndpointIpAddressesRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest,
      ListResolverEndpointIpAddressesResponse
    ]("listResolverEndpointIpAddresses", api.listResolverEndpointIpAddresses)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.wrap
    ).provideEnvironment(r)
    def listResolverEndpoints(
        request: ListResolverEndpointsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest,
      ListResolverEndpointsResponse,
      ResolverEndpoint
    ](
      "listResolverEndpoints",
      api.listResolverEndpoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resolverEndpoints().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53resolver.model.ListResolverEndpointsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.route53resolver.model.ResolverEndpoint.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResolverEndpointsPaginated(
        request: ListResolverEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest,
      ListResolverEndpointsResponse
    ]("listResolverEndpoints", api.listResolverEndpoints)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.ListResolverEndpointsResponse.wrap)
      .provideEnvironment(r)
    def listResolverRules(
        request: ListResolverRulesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest,
      ListResolverRulesResponse,
      ResolverRule
    ](
      "listResolverRules",
      api.listResolverRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resolverRules().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53resolver.model.ListResolverRulesResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.route53resolver.model.ResolverRule.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResolverRulesPaginated(request: ListResolverRulesRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest,
      ListResolverRulesResponse
    ]("listResolverRules", api.listResolverRules)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.ListResolverRulesResponse.wrap)
      .provideEnvironment(r)
    def deleteFirewallRule(request: DeleteFirewallRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest,
      DeleteFirewallRuleResponse
    ]("deleteFirewallRule", api.deleteFirewallRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.DeleteFirewallRuleResponse.wrap)
      .provideEnvironment(r)
    def associateResolverQueryLogConfig(
        request: AssociateResolverQueryLogConfigRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.AssociateResolverQueryLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigRequest,
      AssociateResolverQueryLogConfigResponse
    ]("associateResolverQueryLogConfig", api.associateResolverQueryLogConfig)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.AssociateResolverQueryLogConfigResponse.wrap
    ).provideEnvironment(r)
    def listFirewallDomains(
        request: ListFirewallDomainsRequest
    ): ZStream[Any, AwsError, FirewallDomainName] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest,
      ListFirewallDomainsResponse,
      java.lang.String
    ](
      "listFirewallDomains",
      api.listFirewallDomains,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domains().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53resolver.model.primitives.FirewallDomainName(item)
      )
      .provideEnvironment(r)
    def listFirewallDomainsPaginated(request: ListFirewallDomainsRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest,
      ListFirewallDomainsResponse
    ]("listFirewallDomains", api.listFirewallDomains)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.ListFirewallDomainsResponse.wrap)
      .provideEnvironment(r)
    def getFirewallDomainList(request: GetFirewallDomainListRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest,
      GetFirewallDomainListResponse
    ]("getFirewallDomainList", api.getFirewallDomainList)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.GetFirewallDomainListResponse.wrap)
      .provideEnvironment(r)
    def createFirewallRuleGroup(request: CreateFirewallRuleGroupRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.CreateFirewallRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleGroupRequest,
      CreateFirewallRuleGroupResponse
    ]("createFirewallRuleGroup", api.createFirewallRuleGroup)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.CreateFirewallRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def disassociateResolverEndpointIpAddress(
        request: DisassociateResolverEndpointIpAddressRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.DisassociateResolverEndpointIpAddressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressRequest,
      DisassociateResolverEndpointIpAddressResponse
    ](
      "disassociateResolverEndpointIpAddress",
      api.disassociateResolverEndpointIpAddress
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.DisassociateResolverEndpointIpAddressResponse.wrap
      )
      .provideEnvironment(r)
    def updateResolverRule(request: UpdateResolverRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest,
      UpdateResolverRuleResponse
    ]("updateResolverRule", api.updateResolverRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.UpdateResolverRuleResponse.wrap)
      .provideEnvironment(r)
    def createResolverEndpoint(request: CreateResolverEndpointRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.CreateResolverEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest,
      CreateResolverEndpointResponse
    ]("createResolverEndpoint", api.createResolverEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.CreateResolverEndpointResponse.wrap)
      .provideEnvironment(r)
    def listResolverRuleAssociations(
        request: ListResolverRuleAssociationsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest,
      ListResolverRuleAssociationsResponse,
      ResolverRuleAssociation
    ](
      "listResolverRuleAssociations",
      api.listResolverRuleAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resolverRuleAssociations().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.route53resolver.model.ResolverRuleAssociation.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResolverRuleAssociationsPaginated(
        request: ListResolverRuleAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest,
      ListResolverRuleAssociationsResponse
    ]("listResolverRuleAssociations", api.listResolverRuleAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.wrap
    ).provideEnvironment(r)
    def updateResolverEndpoint(request: UpdateResolverEndpointRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest,
      UpdateResolverEndpointResponse
    ]("updateResolverEndpoint", api.updateResolverEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.UpdateResolverEndpointResponse.wrap)
      .provideEnvironment(r)
    def putResolverRulePolicy(request: PutResolverRulePolicyRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest,
      PutResolverRulePolicyResponse
    ]("putResolverRulePolicy", api.putResolverRulePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.PutResolverRulePolicyResponse.wrap)
      .provideEnvironment(r)
    def getFirewallRuleGroupPolicy(
        request: GetFirewallRuleGroupPolicyRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest,
      GetFirewallRuleGroupPolicyResponse
    ]("getFirewallRuleGroupPolicy", api.getFirewallRuleGroupPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.wrap)
      .provideEnvironment(r)
    def getResolverRuleAssociation(
        request: GetResolverRuleAssociationRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverRuleAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest,
      GetResolverRuleAssociationResponse
    ]("getResolverRuleAssociation", api.getResolverRuleAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.GetResolverRuleAssociationResponse.wrap)
      .provideEnvironment(r)
    def disassociateFirewallRuleGroup(
        request: DisassociateFirewallRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.DisassociateFirewallRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest,
      DisassociateFirewallRuleGroupResponse
    ]("disassociateFirewallRuleGroup", api.disassociateFirewallRuleGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.DisassociateFirewallRuleGroupResponse.wrap
    ).provideEnvironment(r)
    def associateFirewallRuleGroup(
        request: AssociateFirewallRuleGroupRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest,
      AssociateFirewallRuleGroupResponse
    ]("associateFirewallRuleGroup", api.associateFirewallRuleGroup)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.wrap)
      .provideEnvironment(r)
    def disassociateResolverRule(request: DisassociateResolverRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.DisassociateResolverRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest,
      DisassociateResolverRuleResponse
    ]("disassociateResolverRule", api.disassociateResolverRule)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.DisassociateResolverRuleResponse.wrap)
      .provideEnvironment(r)
    def getResolverDnssecConfig(request: GetResolverDnssecConfigRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigRequest,
      GetResolverDnssecConfigResponse
    ]("getResolverDnssecConfig", api.getResolverDnssecConfig)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.wrap)
      .provideEnvironment(r)
    def listResolverDnssecConfigs(
        request: ListResolverDnssecConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest,
      ListResolverDnssecConfigsResponse,
      ResolverDnssecConfig
    ](
      "listResolverDnssecConfigs",
      api.listResolverDnssecConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resolverDnssecConfigs().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53resolver.model.ResolverDnssecConfig.wrap(item)
      )
      .provideEnvironment(r)
    def listResolverDnssecConfigsPaginated(
        request: ListResolverDnssecConfigsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest,
      ListResolverDnssecConfigsResponse
    ]("listResolverDnssecConfigs", api.listResolverDnssecConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.wrap)
      .provideEnvironment(r)
    def getResolverRule(request: GetResolverRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest,
      GetResolverRuleResponse
    ]("getResolverRule", api.getResolverRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.GetResolverRuleResponse.wrap)
      .provideEnvironment(r)
    def disassociateResolverQueryLogConfig(
        request: DisassociateResolverQueryLogConfigRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest,
      DisassociateResolverQueryLogConfigResponse
    ](
      "disassociateResolverQueryLogConfig",
      api.disassociateResolverQueryLogConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.wrap
      )
      .provideEnvironment(r)
    def listFirewallConfigs(request: ListFirewallConfigsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest,
      ListFirewallConfigsResponse,
      FirewallConfig
    ](
      "listFirewallConfigs",
      api.listFirewallConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewallConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.route53resolver.model.FirewallConfig.wrap(item))
      .provideEnvironment(r)
    def listFirewallConfigsPaginated(request: ListFirewallConfigsRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest,
      ListFirewallConfigsResponse
    ]("listFirewallConfigs", api.listFirewallConfigs)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.ListFirewallConfigsResponse.wrap)
      .provideEnvironment(r)
    def updateFirewallRuleGroupAssociation(
        request: UpdateFirewallRuleGroupAssociationRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest,
      UpdateFirewallRuleGroupAssociationResponse
    ](
      "updateFirewallRuleGroupAssociation",
      api.updateFirewallRuleGroupAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def updateFirewallDomains(request: UpdateFirewallDomainsRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest,
      UpdateFirewallDomainsResponse
    ]("updateFirewallDomains", api.updateFirewallDomains)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.wrap)
      .provideEnvironment(r)
    def getResolverRulePolicy(request: GetResolverRulePolicyRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest,
      GetResolverRulePolicyResponse
    ]("getResolverRulePolicy", api.getResolverRulePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.GetResolverRulePolicyResponse.wrap)
      .provideEnvironment(r)
    def createResolverQueryLogConfig(
        request: CreateResolverQueryLogConfigRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest,
      CreateResolverQueryLogConfigResponse
    ]("createResolverQueryLogConfig", api.createResolverQueryLogConfig)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.wrap
    ).provideEnvironment(r)
    def deleteFirewallDomainList(request: DeleteFirewallDomainListRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest,
      DeleteFirewallDomainListResponse
    ]("deleteFirewallDomainList", api.deleteFirewallDomainList)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.wrap)
      .provideEnvironment(r)
    def getResolverEndpoint(request: GetResolverEndpointRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest,
      GetResolverEndpointResponse
    ]("getResolverEndpoint", api.getResolverEndpoint)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.GetResolverEndpointResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getResolverQueryLogConfigAssociation(
        request: GetResolverQueryLogConfigAssociationRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest,
      GetResolverQueryLogConfigAssociationResponse
    ](
      "getResolverQueryLogConfigAssociation",
      api.getResolverQueryLogConfigAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def listResolverConfigs(request: ListResolverConfigsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest,
      ListResolverConfigsResponse,
      ResolverConfig
    ](
      "listResolverConfigs",
      api.listResolverConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resolverConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.route53resolver.model.ResolverConfig.wrap(item))
      .provideEnvironment(r)
    def listResolverConfigsPaginated(request: ListResolverConfigsRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest,
      ListResolverConfigsResponse
    ]("listResolverConfigs", api.listResolverConfigs)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.ListResolverConfigsResponse.wrap)
      .provideEnvironment(r)
    def listResolverQueryLogConfigs(
        request: ListResolverQueryLogConfigsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest,
      ListResolverQueryLogConfigsResponse,
      ResolverQueryLogConfig
    ](
      "listResolverQueryLogConfigs",
      api.listResolverQueryLogConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resolverQueryLogConfigs().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.route53resolver.model.ResolverQueryLogConfig.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResolverQueryLogConfigsPaginated(
        request: ListResolverQueryLogConfigsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest,
      ListResolverQueryLogConfigsResponse
    ]("listResolverQueryLogConfigs", api.listResolverQueryLogConfigs)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.wrap
    ).provideEnvironment(r)
    def listResolverQueryLogConfigAssociations(
        request: ListResolverQueryLogConfigAssociationsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest,
      ListResolverQueryLogConfigAssociationsResponse,
      ResolverQueryLogConfigAssociation
    ](
      "listResolverQueryLogConfigAssociations",
      api.listResolverQueryLogConfigAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.resolverQueryLogConfigAssociations().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
                .wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listResolverQueryLogConfigAssociationsPaginated(
        request: ListResolverQueryLogConfigAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest,
      ListResolverQueryLogConfigAssociationsResponse
    ](
      "listResolverQueryLogConfigAssociations",
      api.listResolverQueryLogConfigAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def putFirewallRuleGroupPolicy(
        request: PutFirewallRuleGroupPolicyRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest,
      PutFirewallRuleGroupPolicyResponse
    ]("putFirewallRuleGroupPolicy", api.putFirewallRuleGroupPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.route53resolver.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.route53resolver.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def getFirewallRuleGroupAssociation(
        request: GetFirewallRuleGroupAssociationRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest,
      GetFirewallRuleGroupAssociationResponse
    ]("getFirewallRuleGroupAssociation", api.getFirewallRuleGroupAssociation)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationResponse.wrap
    ).provideEnvironment(r)
    def associateResolverEndpointIpAddress(
        request: AssociateResolverEndpointIpAddressRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest,
      AssociateResolverEndpointIpAddressResponse
    ](
      "associateResolverEndpointIpAddress",
      api.associateResolverEndpointIpAddress
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def importFirewallDomains(request: ImportFirewallDomainsRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest,
      ImportFirewallDomainsResponse
    ]("importFirewallDomains", api.importFirewallDomains)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.ImportFirewallDomainsResponse.wrap)
      .provideEnvironment(r)
    def deleteResolverEndpoint(request: DeleteResolverEndpointRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest,
      DeleteResolverEndpointResponse
    ]("deleteResolverEndpoint", api.deleteResolverEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.DeleteResolverEndpointResponse.wrap)
      .provideEnvironment(r)
    def listFirewallRuleGroupAssociations(
        request: ListFirewallRuleGroupAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest,
      ListFirewallRuleGroupAssociationsResponse,
      FirewallRuleGroupAssociation
    ](
      "listFirewallRuleGroupAssociations",
      api.listFirewallRuleGroupAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewallRuleGroupAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53resolver.model.FirewallRuleGroupAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def listFirewallRuleGroupAssociationsPaginated(
        request: ListFirewallRuleGroupAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest,
      ListFirewallRuleGroupAssociationsResponse
    ](
      "listFirewallRuleGroupAssociations",
      api.listFirewallRuleGroupAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def listFirewallRules(request: ListFirewallRulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest,
      ListFirewallRulesResponse,
      FirewallRule
    ](
      "listFirewallRules",
      api.listFirewallRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewallRules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.route53resolver.model.FirewallRule.wrap(item))
      .provideEnvironment(r)
    def listFirewallRulesPaginated(request: ListFirewallRulesRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest,
      ListFirewallRulesResponse
    ]("listFirewallRules", api.listFirewallRules)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.ListFirewallRulesResponse.wrap)
      .provideEnvironment(r)
    def listFirewallRuleGroups(request: ListFirewallRuleGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest,
      ListFirewallRuleGroupsResponse,
      FirewallRuleGroupMetadata
    ](
      "listFirewallRuleGroups",
      api.listFirewallRuleGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.firewallRuleGroups().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53resolver.model.FirewallRuleGroupMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listFirewallRuleGroupsPaginated(
        request: ListFirewallRuleGroupsRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest,
      ListFirewallRuleGroupsResponse
    ]("listFirewallRuleGroups", api.listFirewallRuleGroups)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteResolverRule(request: DeleteResolverRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest,
      DeleteResolverRuleResponse
    ]("deleteResolverRule", api.deleteResolverRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.DeleteResolverRuleResponse.wrap)
      .provideEnvironment(r)
    def getResolverConfig(request: GetResolverConfigRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest,
      GetResolverConfigResponse
    ]("getResolverConfig", api.getResolverConfig)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.GetResolverConfigResponse.wrap)
      .provideEnvironment(r)
    def updateFirewallRule(request: UpdateFirewallRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest,
      UpdateFirewallRuleResponse
    ]("updateFirewallRule", api.updateFirewallRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.UpdateFirewallRuleResponse.wrap)
      .provideEnvironment(r)
    def getResolverQueryLogConfigPolicy(
        request: GetResolverQueryLogConfigPolicyRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest,
      GetResolverQueryLogConfigPolicyResponse
    ]("getResolverQueryLogConfigPolicy", api.getResolverQueryLogConfigPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.wrap
    ).provideEnvironment(r)
    def createFirewallDomainList(request: CreateFirewallDomainListRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest,
      CreateFirewallDomainListResponse
    ]("createFirewallDomainList", api.createFirewallDomainList)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.CreateFirewallDomainListResponse.wrap)
      .provideEnvironment(r)
    def getFirewallConfig(request: GetFirewallConfigRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest,
      GetFirewallConfigResponse
    ]("getFirewallConfig", api.getFirewallConfig)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.GetFirewallConfigResponse.wrap)
      .provideEnvironment(r)
    def updateResolverDnssecConfig(
        request: UpdateResolverDnssecConfigRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest,
      UpdateResolverDnssecConfigResponse
    ]("updateResolverDnssecConfig", api.updateResolverDnssecConfig)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.wrap)
      .provideEnvironment(r)
    def associateResolverRule(request: AssociateResolverRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest,
      AssociateResolverRuleResponse
    ]("associateResolverRule", api.associateResolverRule)(
      request.buildAwsValue()
    ).map(zio.aws.route53resolver.model.AssociateResolverRuleResponse.wrap)
      .provideEnvironment(r)
    def createResolverRule(request: CreateResolverRuleRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest,
      CreateResolverRuleResponse
    ]("createResolverRule", api.createResolverRule)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.CreateResolverRuleResponse.wrap)
      .provideEnvironment(r)
    def putResolverQueryLogConfigPolicy(
        request: PutResolverQueryLogConfigPolicyRequest
    ): IO[
      AwsError,
      zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest,
      PutResolverQueryLogConfigPolicyResponse
    ]("putResolverQueryLogConfigPolicy", api.putResolverQueryLogConfigPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.wrap
    ).provideEnvironment(r)
    def getFirewallRuleGroup(request: GetFirewallRuleGroupRequest): IO[
      AwsError,
      zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest,
      GetFirewallRuleGroupResponse
    ]("getFirewallRuleGroup", api.getFirewallRuleGroup)(request.buildAwsValue())
      .map(zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.wrap)
      .provideEnvironment(r)
  }
  def updateFirewallConfig(request: UpdateFirewallConfigRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallConfig(request))
  def deleteFirewallRuleGroup(
      request: DeleteFirewallRuleGroupRequest
  ): ZIO[zio.aws.route53resolver.Route53Resolver, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteFirewallRuleGroup(request))
  def listFirewallDomainLists(request: ListFirewallDomainListsRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewallDomainLists(request))
  def listFirewallDomainListsPaginated(
      request: ListFirewallDomainListsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallDomainListsPaginated(request))
  def deleteResolverQueryLogConfig(
      request: DeleteResolverQueryLogConfigRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResolverQueryLogConfig(request))
  def getResolverQueryLogConfig(request: GetResolverQueryLogConfigRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverQueryLogConfig(request))
  def createFirewallRule(request: CreateFirewallRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.CreateFirewallRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFirewallRule(request))
  def updateResolverConfig(request: UpdateResolverConfigRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResolverConfig(request))
  def listResolverEndpointIpAddresses(
      request: ListResolverEndpointIpAddressesRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly,
      zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listResolverEndpointIpAddresses(request))
  def listResolverEndpointIpAddressesPaginated(
      request: ListResolverEndpointIpAddressesRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverEndpointIpAddressesPaginated(request))
  def listResolverEndpoints(request: ListResolverEndpointsRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listResolverEndpoints(request))
  def listResolverEndpointsPaginated(
      request: ListResolverEndpointsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverEndpointsPaginated(request))
  def listResolverRules(request: ListResolverRulesRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listResolverRules(request))
  def listResolverRulesPaginated(request: ListResolverRulesRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverRulesPaginated(request))
  def deleteFirewallRule(request: DeleteFirewallRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DeleteFirewallRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFirewallRule(request))
  def associateResolverQueryLogConfig(
      request: AssociateResolverQueryLogConfigRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.AssociateResolverQueryLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateResolverQueryLogConfig(request))
  def listFirewallDomains(request: ListFirewallDomainsRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    FirewallDomainName
  ] = ZStream.serviceWithStream(_.listFirewallDomains(request))
  def listFirewallDomainsPaginated(request: ListFirewallDomainsRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallDomainsPaginated(request))
  def getFirewallDomainList(request: GetFirewallDomainListRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetFirewallDomainListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFirewallDomainList(request))
  def createFirewallRuleGroup(request: CreateFirewallRuleGroupRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.CreateFirewallRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFirewallRuleGroup(request))
  def disassociateResolverEndpointIpAddress(
      request: DisassociateResolverEndpointIpAddressRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DisassociateResolverEndpointIpAddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateResolverEndpointIpAddress(request))
  def updateResolverRule(request: UpdateResolverRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResolverRule(request))
  def createResolverEndpoint(request: CreateResolverEndpointRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.CreateResolverEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResolverEndpoint(request))
  def listResolverRuleAssociations(
      request: ListResolverRuleAssociationsRequest
  ): ZIO[zio.aws.route53resolver.Route53Resolver, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly,
    zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listResolverRuleAssociations(request))
  def listResolverRuleAssociationsPaginated(
      request: ListResolverRuleAssociationsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverRuleAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverRuleAssociationsPaginated(request))
  def updateResolverEndpoint(request: UpdateResolverEndpointRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResolverEndpoint(request))
  def putResolverRulePolicy(request: PutResolverRulePolicyRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResolverRulePolicy(request))
  def getFirewallRuleGroupPolicy(
      request: GetFirewallRuleGroupPolicyRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFirewallRuleGroupPolicy(request))
  def getResolverRuleAssociation(
      request: GetResolverRuleAssociationRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverRuleAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverRuleAssociation(request))
  def disassociateFirewallRuleGroup(
      request: DisassociateFirewallRuleGroupRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DisassociateFirewallRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFirewallRuleGroup(request))
  def associateFirewallRuleGroup(
      request: AssociateFirewallRuleGroupRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.AssociateFirewallRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateFirewallRuleGroup(request))
  def disassociateResolverRule(request: DisassociateResolverRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DisassociateResolverRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateResolverRule(request))
  def getResolverDnssecConfig(request: GetResolverDnssecConfigRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverDnssecConfig(request))
  def listResolverDnssecConfigs(
      request: ListResolverDnssecConfigsRequest
  ): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listResolverDnssecConfigs(request))
  def listResolverDnssecConfigsPaginated(
      request: ListResolverDnssecConfigsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverDnssecConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverDnssecConfigsPaginated(request))
  def getResolverRule(request: GetResolverRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverRule(request))
  def disassociateResolverQueryLogConfig(
      request: DisassociateResolverQueryLogConfigRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DisassociateResolverQueryLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateResolverQueryLogConfig(request))
  def listFirewallConfigs(request: ListFirewallConfigsRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.FirewallConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewallConfigs(request))
  def listFirewallConfigsPaginated(request: ListFirewallConfigsRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallConfigsPaginated(request))
  def updateFirewallRuleGroupAssociation(
      request: UpdateFirewallRuleGroupAssociationRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallRuleGroupAssociation(request))
  def updateFirewallDomains(request: UpdateFirewallDomainsRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallDomains(request))
  def getResolverRulePolicy(request: GetResolverRulePolicyRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverRulePolicy(request))
  def createResolverQueryLogConfig(
      request: CreateResolverQueryLogConfigRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResolverQueryLogConfig(request))
  def deleteFirewallDomainList(request: DeleteFirewallDomainListRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFirewallDomainList(request))
  def getResolverEndpoint(request: GetResolverEndpointRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverEndpoint(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getResolverQueryLogConfigAssociation(
      request: GetResolverQueryLogConfigAssociationRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverQueryLogConfigAssociation(request))
  def listResolverConfigs(request: ListResolverConfigsRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ResolverConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listResolverConfigs(request))
  def listResolverConfigsPaginated(request: ListResolverConfigsRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverConfigsPaginated(request))
  def listResolverQueryLogConfigs(
      request: ListResolverQueryLogConfigsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listResolverQueryLogConfigs(request))
  def listResolverQueryLogConfigsPaginated(
      request: ListResolverQueryLogConfigsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverQueryLogConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolverQueryLogConfigsPaginated(request))
  def listResolverQueryLogConfigAssociations(
      request: ListResolverQueryLogConfigAssociationsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly,
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listResolverQueryLogConfigAssociations(request))
  def listResolverQueryLogConfigAssociationsPaginated(
      request: ListResolverQueryLogConfigAssociationsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listResolverQueryLogConfigAssociationsPaginated(request)
  )
  def putFirewallRuleGroupPolicy(
      request: PutFirewallRuleGroupPolicyRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFirewallRuleGroupPolicy(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def getFirewallRuleGroupAssociation(
      request: GetFirewallRuleGroupAssociationRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetFirewallRuleGroupAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFirewallRuleGroupAssociation(request))
  def associateResolverEndpointIpAddress(
      request: AssociateResolverEndpointIpAddressRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.AssociateResolverEndpointIpAddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateResolverEndpointIpAddress(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def importFirewallDomains(request: ImportFirewallDomainsRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ImportFirewallDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importFirewallDomains(request))
  def deleteResolverEndpoint(request: DeleteResolverEndpointRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DeleteResolverEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResolverEndpoint(request))
  def listFirewallRuleGroupAssociations(
      request: ListFirewallRuleGroupAssociationsRequest
  ): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.FirewallRuleGroupAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewallRuleGroupAssociations(request))
  def listFirewallRuleGroupAssociationsPaginated(
      request: ListFirewallRuleGroupAssociationsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListFirewallRuleGroupAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallRuleGroupAssociationsPaginated(request))
  def listFirewallRules(request: ListFirewallRulesRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.FirewallRule.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewallRules(request))
  def listFirewallRulesPaginated(request: ListFirewallRulesRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallRulesPaginated(request))
  def listFirewallRuleGroups(request: ListFirewallRuleGroupsRequest): ZStream[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listFirewallRuleGroups(request))
  def listFirewallRuleGroupsPaginated(
      request: ListFirewallRuleGroupsRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.ListFirewallRuleGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFirewallRuleGroupsPaginated(request))
  def deleteResolverRule(request: DeleteResolverRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResolverRule(request))
  def getResolverConfig(request: GetResolverConfigRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverConfig(request))
  def updateFirewallRule(request: UpdateFirewallRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateFirewallRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFirewallRule(request))
  def getResolverQueryLogConfigPolicy(
      request: GetResolverQueryLogConfigPolicyRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetResolverQueryLogConfigPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolverQueryLogConfigPolicy(request))
  def createFirewallDomainList(request: CreateFirewallDomainListRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.CreateFirewallDomainListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFirewallDomainList(request))
  def getFirewallConfig(request: GetFirewallConfigRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFirewallConfig(request))
  def updateResolverDnssecConfig(
      request: UpdateResolverDnssecConfigRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResolverDnssecConfig(request))
  def associateResolverRule(request: AssociateResolverRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.AssociateResolverRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateResolverRule(request))
  def createResolverRule(request: CreateResolverRuleRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.CreateResolverRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResolverRule(request))
  def putResolverQueryLogConfigPolicy(
      request: PutResolverQueryLogConfigPolicyRequest
  ): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResolverQueryLogConfigPolicy(request))
  def getFirewallRuleGroup(request: GetFirewallRuleGroupRequest): ZIO[
    zio.aws.route53resolver.Route53Resolver,
    AwsError,
    zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFirewallRuleGroup(request))
}
