package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFirewallConfigsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    firewallConfigs: Optional[
      Iterable[zio.aws.route53resolver.model.FirewallConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse = {
    import ListFirewallConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewallConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallConfigsResponse
      .wrap(buildAwsValue())
}
object ListFirewallConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListFirewallConfigsResponse =
      zio.aws.route53resolver.model.ListFirewallConfigsResponse(
        nextToken.map(value => value),
        firewallConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def firewallConfigs
        : Optional[List[zio.aws.route53resolver.model.FirewallConfig.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewallConfigs: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.FirewallConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("firewallConfigs", firewallConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse
  ) extends zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val firewallConfigs: Optional[
      List[zio.aws.route53resolver.model.FirewallConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.FirewallConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse
  ): zio.aws.route53resolver.model.ListFirewallConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
