package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class UpdateResolverDnssecConfigRequest(
    resourceId: ResourceId,
    validation: zio.aws.route53resolver.model.Validation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest = {
    import UpdateResolverDnssecConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .validation(validation.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverDnssecConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverDnssecConfigRequest
      .wrap(buildAwsValue())
}
object UpdateResolverDnssecConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateResolverDnssecConfigRequest =
      zio.aws.route53resolver.model
        .UpdateResolverDnssecConfigRequest(resourceId, validation)
    def resourceId: ResourceId
    def validation: zio.aws.route53resolver.model.Validation
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getValidation
        : ZIO[Any, Nothing, zio.aws.route53resolver.model.Validation] =
      ZIO.succeed(validation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest
  ) extends zio.aws.route53resolver.model.UpdateResolverDnssecConfigRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resourceId())
    override val validation: zio.aws.route53resolver.model.Validation =
      zio.aws.route53resolver.model.Validation.wrap(impl.validation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest
  ): zio.aws.route53resolver.model.UpdateResolverDnssecConfigRequest.ReadOnly =
    new Wrapper(impl)
}
