package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetFirewallDomainListRequest(
    firewallDomainListId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest = {
    import GetFirewallDomainListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest
      .builder()
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallDomainListRequest.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallDomainListRequest
      .wrap(buildAwsValue())
}
object GetFirewallDomainListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetFirewallDomainListRequest =
      zio.aws.route53resolver.model
        .GetFirewallDomainListRequest(firewallDomainListId)
    def firewallDomainListId: ResourceId
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest
  ) extends zio.aws.route53resolver.model.GetFirewallDomainListRequest.ReadOnly {
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest
  ): zio.aws.route53resolver.model.GetFirewallDomainListRequest.ReadOnly =
    new Wrapper(impl)
}
