package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetFirewallRuleGroupRequest(firewallRuleGroupId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest = {
    import GetFirewallRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest
      .builder()
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallRuleGroupRequest.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallRuleGroupRequest
      .wrap(buildAwsValue())
}
object GetFirewallRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetFirewallRuleGroupRequest =
      zio.aws.route53resolver.model
        .GetFirewallRuleGroupRequest(firewallRuleGroupId)
    def firewallRuleGroupId: ResourceId
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest
  ) extends zio.aws.route53resolver.model.GetFirewallRuleGroupRequest.ReadOnly {
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest
  ): zio.aws.route53resolver.model.GetFirewallRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
