package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  BlockOverrideDomain,
  CreatorRequestId,
  Unsigned,
  Priority,
  Rfc3339TimeString,
  Name,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FirewallRule(
    firewallRuleGroupId: Optional[ResourceId] = Optional.Absent,
    firewallDomainListId: Optional[ResourceId] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    priority: Optional[Priority] = Optional.Absent,
    action: Optional[zio.aws.route53resolver.model.Action] = Optional.Absent,
    blockResponse: Optional[zio.aws.route53resolver.model.BlockResponse] =
      Optional.Absent,
    blockOverrideDomain: Optional[BlockOverrideDomain] = Optional.Absent,
    blockOverrideDnsType: Optional[
      zio.aws.route53resolver.model.BlockOverrideDnsType
    ] = Optional.Absent,
    blockOverrideTtl: Optional[Unsigned] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallRule = {
    import FirewallRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallRule
      .builder()
      .optionallyWith(
        firewallRuleGroupId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallRuleGroupId)
      .optionallyWith(
        firewallDomainListId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallDomainListId)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(blockResponse.map(value => value.unwrap))(_.blockResponse)
      .optionallyWith(
        blockOverrideDomain.map(value =>
          BlockOverrideDomain.unwrap(value): java.lang.String
        )
      )(_.blockOverrideDomain)
      .optionallyWith(blockOverrideDnsType.map(value => value.unwrap))(
        _.blockOverrideDnsType
      )
      .optionallyWith(
        blockOverrideTtl.map(value => Unsigned.unwrap(value): Integer)
      )(_.blockOverrideTtl)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.FirewallRule.ReadOnly =
    zio.aws.route53resolver.model.FirewallRule.wrap(buildAwsValue())
}
object FirewallRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallRule =
      zio.aws.route53resolver.model.FirewallRule(
        firewallRuleGroupId.map(value => value),
        firewallDomainListId.map(value => value),
        name.map(value => value),
        priority.map(value => value),
        action.map(value => value),
        blockResponse.map(value => value),
        blockOverrideDomain.map(value => value),
        blockOverrideDnsType.map(value => value),
        blockOverrideTtl.map(value => value),
        creatorRequestId.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def firewallRuleGroupId: Optional[ResourceId]
    def firewallDomainListId: Optional[ResourceId]
    def name: Optional[Name]
    def priority: Optional[Priority]
    def action: Optional[zio.aws.route53resolver.model.Action]
    def blockResponse: Optional[zio.aws.route53resolver.model.BlockResponse]
    def blockOverrideDomain: Optional[BlockOverrideDomain]
    def blockOverrideDnsType
        : Optional[zio.aws.route53resolver.model.BlockOverrideDnsType]
    def blockOverrideTtl: Optional[Unsigned]
    def creatorRequestId: Optional[CreatorRequestId]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def getFirewallRuleGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallRuleGroupId", firewallRuleGroupId)
    def getFirewallDomainListId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallDomainListId", firewallDomainListId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getAction: ZIO[Any, AwsError, zio.aws.route53resolver.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBlockResponse
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.BlockResponse] =
      AwsError.unwrapOptionField("blockResponse", blockResponse)
    def getBlockOverrideDomain: ZIO[Any, AwsError, BlockOverrideDomain] =
      AwsError.unwrapOptionField("blockOverrideDomain", blockOverrideDomain)
    def getBlockOverrideDnsType: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.BlockOverrideDnsType
    ] = AwsError.unwrapOptionField("blockOverrideDnsType", blockOverrideDnsType)
    def getBlockOverrideTtl: ZIO[Any, AwsError, Unsigned] =
      AwsError.unwrapOptionField("blockOverrideTtl", blockOverrideTtl)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRule
  ) extends zio.aws.route53resolver.model.FirewallRule.ReadOnly {
    override val firewallRuleGroupId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRuleGroupId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ResourceId(value)
        )
    override val firewallDomainListId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallDomainListId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.ResourceId(value)
        )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.route53resolver.model.primitives.Priority(value))
    override val action: Optional[zio.aws.route53resolver.model.Action] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.route53resolver.model.Action.wrap(value))
    override val blockResponse
        : Optional[zio.aws.route53resolver.model.BlockResponse] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockResponse())
        .map(value => zio.aws.route53resolver.model.BlockResponse.wrap(value))
    override val blockOverrideDomain: Optional[BlockOverrideDomain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockOverrideDomain())
        .map(value =>
          zio.aws.route53resolver.model.primitives.BlockOverrideDomain(value)
        )
    override val blockOverrideDnsType
        : Optional[zio.aws.route53resolver.model.BlockOverrideDnsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockOverrideDnsType())
        .map(value =>
          zio.aws.route53resolver.model.BlockOverrideDnsType.wrap(value)
        )
    override val blockOverrideTtl: Optional[Unsigned] = zio.aws.core.internal
      .optionalFromNullable(impl.blockOverrideTtl())
      .map(value => zio.aws.route53resolver.model.primitives.Unsigned(value))
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRule
  ): zio.aws.route53resolver.model.FirewallRule.ReadOnly = new Wrapper(impl)
}
